// basic xbee example
// - take chars from the terminal, push them out xbee1
// - listen on xbee2, and print value + 1 to terminal

#include "mbed.h"
#include "Motor.h"
Motor B(p21,p22,p23);//wd, rev, can brake right motor
Motor A(p26,p24,p25);//wm, fwd, rev, can brake  left motir

Serial xbee2(p9, p10);
DigitalOut rst2(p11);


Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AnalogIn battery(p20);
AnalogIn sensor(p18);

float s=0.8 ;//speed of forward and backward, set to 0.8 for a medium speed

int main()
{
    rst2 = 0; //reset Xbee to initialize
    wait_ms(100);
    rst2 = 1;
    while (1) 
    {
        int b;
        b = xbee2.getc();
        if (b==11) {   //move forward
            led1 = 1;
            A.speed(s);
            B.speed(s);
        } else if (b==12) {   // move backward
            led2 = 1;
            A.speed(-s);
            B.speed(-s);
        } else if (b==13) {       // move left
            led3 = 1;
            A.speed(s+0.2);
            B.speed(s-0.2);
        } else if (b==14) {      // move right
            led4 = 1;
            A.speed(s-0.2);
            B.speed(s+0.2);
        } else if (b==15) {

            xbee2.putc(int(float(232)*battery));
        } else if (b==16) {
            xbee2.putc(int(float(232)*sensor));

        } else if (b==0){
            // stops the motor if no command
            A.speed(0);
            B.speed(0);
        }

        wait(0.01);
        led1=led2=led3=led4=0; //reset leds    
    }

}