
#include "mbed.h"
#include "DebounceIn.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include "rtos.h"

Ticker flipper;
uLCD_4DGL uLCD(p13,p14,p28); // serial tx, serial rx, reset pin;
Serial xbee1(p9, p10);
DigitalOut rst1(p11);
DebounceIn forward(p16);
DebounceIn left(p17);
DebounceIn reverse(p18);
DebounceIn right(p24);
//forward   16
//left      17
//reverse   18
//right     19

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Mutex xbee_lock;
Mutex uLCD_lock;
int a;
volatile int voltage;
volatile int distance;


void read_battery()
{

    xbee1.putc(15);
    //if (xbee1.readable()) {
        uLCD_lock.lock();
        voltage = xbee1.getc();
        uLCD_lock.unlock();
    //}
    //pc.printf("voltage: %i\n",voltage);
}

void read_distance()
{
    xbee1.putc(16);
    //if (xbee1.readable()) {
        uLCD_lock.lock();
        distance = xbee1.getc();
        uLCD_lock.unlock();
    //}
    //pc.printf("distance: %i\n",distance);
}
void display_distance(void const *args)
{
    while(1) {

        uLCD_lock.lock();
        uLCD.locate(1,5);
        float temp = float(1/(float(distance)/232*3.3))*30.53-2.64;
        uLCD.printf("%3.3fcm",temp);
        uLCD_lock.unlock();
        //pc.printf("%i\n",distance);
        Thread::wait(300);

    }
}

void display_battery(void const *args)
{
    while(1) {
        uLCD_lock.lock();
        uLCD.locate(1,3);
        uLCD.printf("%2.2fV",float(voltage)/232*3.3*2);
        //pc.printf("%i\n",voltage);
        uLCD_lock.unlock();
        Thread::wait(300);
    }
}

int main()
{
    forward.mode(PullUp);
    reverse.mode(PullUp);
    left.mode(PullUp);
    right.mode(PullUp);

    // reset the xbees (at least 200ns)
    rst1 = 0;
    wait_ms(100);
    rst1 = 1;
    wait_ms(100);
    uLCD.baudrate(3000000);
    uLCD.cls();
    wait(.01);
    uLCD.locate(1,2);
    uLCD.printf("Battery:\n");
    uLCD.locate(1,4);
    uLCD.printf("Distance:\n");
    //Thread thread2(read_distance);
    //Thread thread3(read_battery);
    Thread thread4(display_distance);
    Thread thread5(display_battery);

    //led1=1;
    //}
    while (1) {
        if (forward==0) {
            led1 = 1;
            xbee1.putc(11);
        } else if (reverse==0) {
            led3 = 1;
            xbee1.putc(12);
        } else if (left==0) {
            led2 = 1;
            xbee1.putc(13);
        } else if (right == 0) {
            led4 = 1;
            xbee1.putc(14);
        } else {
            xbee1.putc(0);
            led1=led2=led3=led4=0;
        }
        read_distance();
        read_battery();
    }
}