#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "ADXL345.h"


PwmOut speaker(p21); //create a PwmOut object for the speaker
uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object
ADXL345 accelerometer(p5, p6, p7, p8);//create a global accelerometer object
Serial pc(USBTX, USBRX);// for debugging
Mutex lcd_mutex;// Create the mutex lock object 

int red_car_x, red_car_y,blue_car_x,blue_car_y,frog_x,frog_y,i,j;
int x=0,y=0;
void thread1(void const *args)//thread 1 moves the red car
{
    
    while(true) {    
         //check for boundary conditions
        if(red_car_x>127){
        red_car_x=-16;
        red_car_y=32;
        
        }
        lcd_mutex.lock();//acquire lock
        uLCD.filled_rectangle(red_car_x,red_car_y,red_car_x+15,red_car_y+15,0x000000);//erase previous position
        red_car_x=red_car_x+16;
        
        for(i=0;i<10;i++){
        uLCD.filled_rectangle(red_car_x,red_car_y,red_car_x+15,red_car_y+15,0xFF3300);//change position
              
        }      
             
        lcd_mutex.unlock();//release the lock
        Thread::wait(500);
    
    }
}


void thread2(void const *args)//thread 1 moves the blue car, code similar to thread 1
{
    
    while(true) {  
           
        if(blue_car_x>127){
        blue_car_x=-16;
        blue_car_y=64;
        
        }
        lcd_mutex.lock();
        uLCD.filled_rectangle(blue_car_x,blue_car_y,blue_car_x+15,blue_car_y+15,0x000000);
        blue_car_x=blue_car_x+16;
        for(i=0;i<5;i++){
        uLCD.filled_rectangle(blue_car_x,blue_car_y,blue_car_x+15,blue_car_y+15,BLUE);//change position
              
        }
                       
        lcd_mutex.unlock();
        Thread::wait(200);
    
    }
}

void thread3(void const *args)//thread 3 plays the sound effects
{
    
     
    while(true) {    
            
        speaker.period(1.0/150.0); // 500hz period
        speaker =0.25; //25% duty cycle - mid range volume
        wait(.02);
        speaker=0.0;//stop the speaker
             
        Thread::wait(500);
    
    }
}
      
int main()
{
       
   A:uLCD.cls();// clear the LCD
    
    uLCD.text_width(2); //2X size text
    uLCD.text_height(2);
    
    
    uLCD.locate(2,2);
    
    uLCD.printf("\n Frogger-G\n");//display the Title
    wait(0.1);
    
    // Sound effects at the start of the game
   for (i=0; i<500; i=i+100) {
        speaker.period(1.0/float(i));
        speaker=0.25;
        wait(.1);
    }
    wait(2);
    uLCD.cls();
    uLCD.text_width(2); //2X size text
    uLCD.text_height(2);
    uLCD.locate(0,0);
    uLCD.color( 0xFF00FF); 
    uLCD.printf("\n Help the  frog \n  cross \nthe road!\n");
    wait (2);
    
    uLCD.cls();
    
    
    red_car_x=0;
    red_car_y=32;
    blue_car_x=0;
    blue_car_y=64;
    frog_x=32;
    frog_y=96;
    //initialize the frog position
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x99FF00);
    uLCD.filled_rectangle(red_car_x,red_car_y,red_car_x+15,red_car_y+15,0xff3300);
    uLCD.filled_rectangle(blue_car_x,blue_car_y,blue_car_x+15,blue_car_y+15,BLUE);
    
    int readings[3] = {0, 0, 0};
    
     //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);
 
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);
    
    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);
 
    //Measurement mode.
    accelerometer.setPowerControl(0x08);
    //Initialize all threads
   Thread t1(thread1); 
   Thread t2(thread2); 
   Thread t3(thread3);
    
    while (1) {
    
        
       for(i=0;i<5;i++)
       //average accelerometer readings for accuracy 
       { 
        accelerometer.getOutput(readings);
        pc.printf("%i, %i, %i            ", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
        x=x+int16_t(readings[0]);
        y=y+int16_t(readings[1]);
        }
        x=int(x/5);
        y=int(y/5);
        
        //debug
       pc.printf("%d, %d   ", int(x),int(y) );
             
        //move the frog according to accelerometer readings
        //thresholds obtained through trial and error
        //move right
        if(y>0){
    lcd_mutex.lock();
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x000000);
    frog_x=frog_x+16;
   
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x99FF00);
    lcd_mutex.unlock();
    }
    //move up
    if(x<70){
        lcd_mutex.lock();
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x000000);
    frog_y=frog_y-16;
    
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x99FF00);
    lcd_mutex.unlock();
    }
    //move left
    if(y<-70){
        lcd_mutex.lock();
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x000000);
    frog_x=frog_x-16;

    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x99FF00);
    lcd_mutex.unlock();
    }
    //move down
    if(x>180){
        lcd_mutex.lock();
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x000000);
    frog_y=frog_y+16;
   
    uLCD.filled_rectangle(frog_x,frog_y,frog_x+15,frog_y+15,0x99FF00);
    lcd_mutex.unlock();
    }
    
    //check collisions
    if ((frog_x==red_car_x & frog_y==red_car_y)|(frog_x==blue_car_x & frog_y==blue_car_y))
    {
    lcd_mutex.lock();    
    uLCD.cls();
       
    uLCD.text_width(2); //2X size text
    uLCD.text_height(2);
    uLCD.color(RED);
    uLCD.locate(2,2);
    uLCD.printf("\n   GAME \n   OVER!\n");// display message
    speaker.period(1.0/500.0); // 500hz period
    speaker =0.5; //50% duty cycle - max volume
    wait(3);
    speaker=0.0; // turn off audio
    
    wait(2);
    lcd_mutex.unlock();
    goto A;//restart the game
    }
    //check if frog has crossed the road
    if (frog_y<32)
    {
     
    lcd_mutex.lock();    
    uLCD.cls();
        
   uLCD.text_width(2); //2X size text
    uLCD.text_height(2);
    uLCD.color(0xffff00);
    uLCD.locate(2,2);
    uLCD.printf("\n   You \n   WIN!\n");//display message
    
    for (i=0; i<500; i=i+100) {
        speaker.period(1.0/float(i));
        speaker=0.25;
        wait(.1);
    }
    wait(5);
    lcd_mutex.unlock();
    goto A;//restart the game
    }
    
    
    Thread::wait(50);   // wait 0.5s
    }  
    
    
    
}