#ifndef GAME_ONE_CHA_H
#define GAME_ONE_CHA_H

#include "N5110.h"
#include "Gamepad.h"
#include "Squirtle.h"
#include "mbed.h"

/** Game One Character Class
* @brief This class defines the parameters for the player and the character in the first mini-game
* @version 1.0
* @author Yiu Fai Kwok
* @date Match, 2019
*/

class Game_one_cha
{

public:

    /** Constructor */
    Game_one_cha();
    /** Destructor */
    ~Game_one_cha();
    
    /**
     * @brief Initialize the class parameters
     * @param The x position x (int)
     * @details Initialize the character's position, speed and player score
     */
    void init(int x);
    
    /**
     * @brief Draw the character
     * @param The character cha (int)
     * @details Draw the character on lcd screen, choose character depending on parameter (cha)
     */
    void draw(N5110 &lcd, int cha);
    
    /**
     * @brief Draw the character's alternative sprite
     * @param The character cha (int)
     * @details Draw the character's alternative sprite on lcd screen to create motion, choose character depending on parameter (cha)
     */
    void draw_alt(N5110 &lcd, int cha);
    
    /**
     * @brief Update the character
     * @param The direction d (Direction)
     * @param The magnitude mag (float)
     * @details Update the character position by referencing the joystick input on direction and magnitue
     */
    void update(Direction d,float mag);
    
    /**
     * @brief Set the score
     * @details Set the score of the player
     */
    void add_score();
    
    /**
     * @brief Get the score
     * @return The current value of score (int)
     * @details Return the score of the player
     */
    int get_score();
    
    /**
     * @brief Get the position of the character
     * @return the current position p (Vector2D)
     * @details Return the position of the character
     */
    Vector2D get_pos();
    
private:
    Squirtle _s1;
    int _x;
    int _y;
    int _speed;
    int _score;
};

#endif