#include "Game_one_cha.h"

Game_one_cha::Game_one_cha()
{

}

Game_one_cha::~Game_one_cha()
{

}

void Game_one_cha::init(int x)
{
    _x = x;    // x position fixed
    _y = HEIGHT/2 - 9;  //y initial position at mid-point of screen
    _speed = 1;  // default speed
    _score = 0;  // start score from zero
}

void Game_one_cha::draw(N5110 &lcd, int cha)
{
    if(cha == 1){_s1.draw_cha1_sprite(_x, _y, lcd);} // draw sprite for Squirtle in year 1
    else if(cha == 2){_s1.draw_cha2_sprite(_x, _y, lcd);} // draw sprite for Wartortle in year 2
    else if(cha == 3){_s1.draw_cha3_sprite(_x, _y, lcd);} // draw sprite for Blastoise in year 3
}

void Game_one_cha::draw_alt(N5110 &lcd, int cha)
{
    if(cha == 1){_s1.draw_cha1_alt_sprite(_x, _y, lcd);} // draw alternative sprite for Squirtle
    else if(cha == 2){_s1.draw_cha2_alt_sprite(_x, _y, lcd);} // draw alternative sprite for Wartortle
    else if(cha == 3){_s1.draw_cha3_alt_sprite(_x, _y, lcd);} // draw alternative sprite for Blastoise
}

void Game_one_cha::update(Direction d,float mag)
{
    _speed = int(mag*10.0f);  // set the scale for speed

    // update y value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == N) {_y-=_speed;} 
    else if (d == S) {_y+=_speed;}

    // check the y origin to ensure that the character doesn't go off screen
    if (_y < 1) {_y = 1;}
    if (_y > HEIGHT - 18) {_y = HEIGHT - 18;}
}

void Game_one_cha::add_score()
{
    _score++; // add up the score for the player for each success coin collection
}

int Game_one_cha::get_score()
{
    return _score; // return score for the player
}

Vector2D Game_one_cha::get_pos()
{
    Vector2D p = {_x,_y}; // return position of the player
    return p;   
}