/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Yiu Fai Kwok
Username: el17yfk
Student ID Number: 201198802
Date: 11/03/2019
*/

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Score.h"
#include "Start.h"
#include "Game_one.h"
#include "Game_two.h"
#include "Game_three.h"
#include "Exam.h"
#include "FXOS8700CQ.h"
#include "rtos.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  // K64F - pwr from 3V3
Gamepad pad;
Score music;
Start start;
Game_one game_1;
Game_two game_2;
Game_three game_3;
Exam test;
Thread thread;
// I2C connection for FXOS8700CQ accelerometer/magnetometer
FXOS8700CQ device(I2C_SDA,I2C_SCL);  // PTE25/PTE24

///////////// prototypes ///////////////
void init();
void welcome();
int menu();
void year_one();
void year_one_set();
void year_two();
void year_two_set();
void year_three();
void year_three_set();
void instruction();
void term_one();
void term_two();
void term_three();
void win();
void lose();
void passed();
void failed();
void gym();

//Starting states
enum StartStates {
    TITLE, MENU, INSTRUCTION 
};

//Game states
enum GameStates {
    YEAR_1, STARTER, BULBASAUR, SQUIRTLE, CHARMANDER, EXAM, YEAR_2, YEAR_3, GRADUATION
};

//Enumerate instruction menu from page 1 - 3
enum Page {
    PAGE_1, PAGE_2, PAGE_3   
};

//Global variables
int score = 0;
int game_1_speed = 0;
int game_1_cha = 0;
int game_1_r = 1;
int game_2_speed = 0;
int game_2_cha = 0;
int game_2_r = 1;
int game_3_set = 1;
float game_3_time = 1.0;
int select = 0;
int year = 0;
int pass = 0;
volatile bool finished = false;

///////////// functions ////////////////
int main(){
    
    // Initialise parameters
    int fps = 8;  // frames per second

    init();     // initialise and then display welcome screen...
    StartStates currentState = TITLE;
    GameStates currentGame = YEAR_1;
    
    while(1){
        switch (currentState) {
        case TITLE:
            // 1. Display title screen and play title music
            // 2. Proceed to Start screen by pressing start
            
            welcome();
            wait(1.0f/fps);
            currentState = MENU;
        break;
        
        case MENU:
            // 1. Display starting menu
            // 2. If Start is selected, initiate year 1 game state
            // 3. If Instruction is selected, give instruction
            
            int op = menu();
            if (op == 1){currentState = INSTRUCTION;}
            else {
                while(1){
                    // Game loop
                    switch (currentGame) {
                        case YEAR_1:
                            // 1. Initiate year 1 screen
                            // 2. Set up the parameters for year 1
                            
                            year_one();
                            year_one_set();
                            currentGame = STARTER;
                        break;
                        
                        case STARTER:
                            // 1. Provide selection screen for starter pokemon to select which mini game to initiate
                            // 2. Provide description for the mini game and pokemon
                            // 3. Initiate the mini game according to the pokemon being selected
                            
                            select = 0;
                            start.init(pad);
                            start.starter_draw(lcd);
                            wait(1.0f/fps);
                            while(pad.check_event(Gamepad::START_PRESSED) == false)
                                {
                                    start.starter_update(pad);
                                    start.starter_draw(lcd);
                                    if(pad.check_event(Gamepad::A_PRESSED) == true){
                                        select = start.get_select(start.update_select(pad));
                                        start.intro(select, pad, lcd);
                                        pad.init_input();
                                    }
                                    wait(1.0f/fps);
                                }
                            select = start.get_select(start.update_select(pad));
                            if(select == 1){
                                music.congrats(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                game_1.intro(pad, lcd);
                                currentGame = SQUIRTLE;
                                pad.init_input();
                            }
                            else if(select == 0){
                                music.congrats(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                game_3.intro(pad, lcd);
                                currentGame = BULBASAUR;
                                pad.init_input();
                            }
                            else if(select == 2){
                                music.congrats(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                game_2.intro(pad, lcd);
                                currentGame = CHARMANDER;
                                pad.init_input();
                            }
                        break;
                        
                        // Game loop for Bulbasaur's mini game
                        case BULBASAUR:
                            int i = 0;
                            score = 0;
                            while(i < 3){
                                // Indicate for which term the current game is in
                                if(i == 0) {term_one();}
                                else if(i == 1) {term_two();}
                                else{term_three();}
                                int j = 0;
                                game_3.init_para();
                                while(j < 5){
                                    // Game loop for 5 rounds
                                    // Set the ratio between messages vs books
                                    game_3.init(pad, game_3_set);
                                    game_3.render(lcd, game_3_set);
                                    // Parameter to set the reaction time frame for varying difficulty
                                    wait(game_3_time);
                                    game_3.read_input(pad);
                                    game_3.update(pad, game_3_set);
                                    j = game_3.get_count();
                                }
                                i = i++;
                                // determine if win condition is met, return score to proceed to EXAM game loop
                                if(game_3.get_score() >= 4) {
                                    win();
                                    music.win(pad);
                                    wait(0.5);
                                    score++;
                                }
                                else {
                                    lose();
                                    pad.tone(750.0,0.2);
                                    wait(0.5);
                                    pad.tone(750.0,0.2);
                                    wait(1.0);
                                }
                            }
                            currentGame = EXAM;
                        break;
                        
                        // Game loop for Squirtle's mini game
                        case SQUIRTLE:
                            i = 0;
                            score = 0;
                            while(i < 3){
                                // Indicate for which term the current game is in
                                if(i == 0) {term_one();}
                                else if(i == 1) {term_two();}
                                else{term_three();}
                                game_1.init(game_1_speed, game_1_cha, game_1_r);
                                int j = 0;
                                while(j < 10){
                                    // Game loop for 10 rounds
                                    game_1.read_input(pad);
                                    game_1.update(pad, lcd);
                                    game_1.render(lcd, game_1_cha);
                                    wait(1.0f/fps);
                                    j = game_1.get_count();
                                }
                                i = i++;
                                // determine if win condition is met, return score to proceed to EXAM game loop
                                if(game_1.print_scores(lcd) >= 8) {
                                    win();
                                    music.win(pad);
                                    wait(0.5);
                                    score++;
                                }
                                else {
                                    lose();
                                    pad.tone(750.0,0.2);
                                    wait(0.5);
                                    pad.tone(750.0,0.2);
                                    wait(1.0);
                                }
                            }
                            currentGame = EXAM;
                            
                        break;
                        
                        // Game loop for Charmander's mini game
                        case CHARMANDER:
                            i = 0;
                            score = 0;
                            while (i < 3) {
                                // Indicate for which term the current game is in
                                if(i == 0) {term_one();}
                                else if(i == 1) {term_two();}
                                else{term_three();}
                                game_2.init(game_2_speed, game_2_cha, game_2_r);
                                int j = 0;
                                while(j < 6){
                                    game_2.read_input(device);
                                    game_2.update(pad, lcd, game_2_cha);
                                    game_2.render(lcd, game_2_cha);
                                    wait(1.0f/fps);
                                    j = game_2.get_count();
                                }
                                i = i++;
                                // determine if win condition is met, return score to proceed to EXAM game loop
                                if(game_2.get_count() == 6) {
                                    win();
                                    music.win(pad);
                                    wait(0.5);
                                    score++;
                                }
                                else {
                                    lose();
                                    pad.tone(750.0,0.2);
                                    wait(0.5);
                                    pad.tone(750.0,0.2);
                                    wait(1.0);
                                }
                            }
                            currentGame = EXAM;
                        break;
                        
                        // Game loop for EXAM
                        case EXAM:
                            // 1. Display the exam questions according to year.
                            // 2. Display the answers according to how many mini games the player passed.
                            // 3. If player manages to answer 2 or 3 questions correctly, enter to next year/GRADUATION.
                            // 4. If player fails, repeat the year.
                            
                            // Reset background music control parameter
                            finished = false;
                            
                            // Draw exam title screen
                            test.exam_title(pad, lcd);
                            
                            // Using thread to run music and exam functions in parallel
                            thread.start(gym);
                            
                            // Check for which year's exam questions need to be fetched
                            if(year == 0) {pass = test.exam_q_one(pad, lcd, score); finished = true;}
                            else if(year == 1) {pass = test.exam_q_two(pad, lcd, score); finished = true;}
                            else if(year == 2) {pass = test.exam_q_three(pad, lcd, score); finished = true;}
                            Thread::wait(1000);
                            thread.join();
                            // End the thread
                            
                            // Check for number of correct answerws to determine if proceed to next year or not
                            if(pass > 2){
                                passed();
                                music.win(pad);
                                wait(0.5);
                                year++;
                                if(year == 1){currentGame = YEAR_2;}
                                else if(year == 2){currentGame = YEAR_3;}
                                else if(year == 3){currentGame = GRADUATION;}
                            }
                            else {
                                failed();
                                pad.tone(750.0,0.2);
                                wait(0.5);
                                pad.tone(750.0,0.2);
                                wait(1.0);
                                if(year == 0){currentGame = YEAR_1;}
                                else if(year == 1){
                                    if(select == 1){currentGame = SQUIRTLE;}
                                    else if(select == 0){currentGame = BULBASAUR;}
                                    else if(select == 2){currentGame = CHARMANDER;}
                                }
                                else if(year == 2){
                                    if(select == 1){currentGame = SQUIRTLE;}
                                    else if(select == 0){currentGame = BULBASAUR;}
                                    else if(select == 2){currentGame = CHARMANDER;}
                                }
                            }
                        break;
                        case YEAR_2:
                            // 1. Initiate year 2 screen
                            // 2. Set up the parameters for year 2
                            // 3. Initiate evolution animation for chosen character
                            // 4. Enter to game loop for chosen character
                            
                            year_two();
                            year_two_set();
                            if(select == 1){
                                music.evolution_music(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                currentGame = SQUIRTLE;
                            }
                            else if(select == 0){
                                music.evolution_music(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                currentGame = BULBASAUR;
                            }
                            else if(select == 2){
                                music.evolution_music(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                currentGame = CHARMANDER;
                            }
                        break;
                        case YEAR_3:
                            // 1. Initiate year 3 screen
                            // 2. Set up the parameters for year 3
                            // 3. Initiate evolution animation for chosen character
                            // 4. Enter to game loop for chosen character
                            
                            year_three();
                            year_three_set();
                            if(select == 1){
                                music.evolution_music(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                currentGame = SQUIRTLE;
                            }
                            else if(select == 0){
                                music.evolution_music(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                currentGame = BULBASAUR;
                            }
                            else if(select == 2){
                                music.evolution_music(pad, lcd, select, year);
                                while(pad.check_event(Gamepad::A_PRESSED) == false){
                                    lcd.printString("PRESS A",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                    lcd.printString("       ",0,5);
                                    lcd.refresh();
                                    wait(0.3);
                                }
                                currentGame = CHARMANDER;
                            }
                        break;
                        case GRADUATION:
                            // 1. Display congratulation theme for player!
                            // 2. Return to the title screen
                            
                            lcd.clear();
                            lcd.printString("GRADUATION!",0,0);
                            lcd.refresh();
                            wait(2.0);
                        break;
                    }
                }
            }
        break;
        
        case INSTRUCTION:
            // 1. Display instruction
            // 2. Return to MENU screen
            
            instruction();
            currentState = MENU;
        break;
        }
    }
}

// initialies all classes and libraries
void init()
{
    lcd.init();
    pad.init();
    device.init();
    // change set contrast in range 0.0 to 1.0
    // 0.4 appears to be a good starting point
    lcd.setContrast(0.4);
}

// simple splash screen displayed on start-up
void welcome() 
{    
        lcd.clear();
        int title_data[35][65] = {
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,1,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,0,1,0,1,0,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,1,0,0,0,1,0,1,1,0,0,1,1,0,0,1,0,0,1,1,0,0,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
            {0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,1,1,1,1,1,0,0},
            {0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,1,1,0,0,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,0,1,1,1,1,0,0,0,1,1,1,0,0,1,1,0,0},
            {0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,0,0,0,1,0,0,0},
            {0,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0},
            {0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0},
            {0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,1,1,0,1,0,1,0,0,0,0,0,0,1,1,0,0,0},
            {0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,1,0,1,0,0,0,0,1,1,1,0,0,1,1,1,1,0,0,1,1,0,1,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0},
            {0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,0,1,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0},
            {0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0},
            {0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,0,0,0,0},
            {0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,1,1,1,1,0,0,0,1,0,0,1,1,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,0,1,1,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            {0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
            {0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0},
            {0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,1,0},
            {0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0},
            {0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,0,1,0,0,1,1,1,0,0,0,0,1,1,1,0},
            {0,1,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0},
            {0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,1,0,0,1,1,1,0,0},
            {0,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,1,1,0,1,0,0,1,1,0,0,0},
            {0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,0,0,0},
            {0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,0,0,0},
            {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        };

        lcd.drawSprite(10, 3, 35, 65, (int*)title_data);
  
        int start_data[5][41] = {
            {1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1},
            {1,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0},
            {1,1,1,0,1,1,1,0,1,1,1,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,1,1,1,0,1,1,1,0,0,1,0},
            {1,0,0,0,1,1,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0},
            {1,0,0,0,1,0,1,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0},
        };
        
        lcd.drawSprite(22, 41, 5, 41, (int*)start_data);
        lcd.refresh();
        music.title_music(pad);

}

// function for displaying the menu screen
int menu()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    int pos_y = 5;
    while(pad.check_event(Gamepad::A_PRESSED) == false){
        lcd.clear();
        if(pad.get_direction() == N){
            pos_y = 5;
        }else if(pad.get_direction() == S){
            pos_y = 16;
        }
      int arrow_data[7][5] = {
            {1,1,0,0,0},
            {0,1,1,0,0},
            {0,0,1,1,0},
            {0,0,0,1,1},
            {0,0,1,1,0},
            {0,1,1,0,0},
            {1,1,0,0,0},
        };
        // draw pointer for selection
        lcd.drawSprite(5, pos_y, 7, 5, (int *)arrow_data);
        
        int op_one_data[7][26] = {
            {1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1},
            {1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0},
            {1,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0},
            {1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,0,1,0,0},
            {0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0},
            {0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0},
            {1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0},
        };
        // draw "START"
        lcd.drawSprite(18, 5, 7, 26, (int *)op_one_data);
        
        int op_two_data[7][18] = {
            {1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1},
            {0,1,0,0,1,0,0,1,0,1,0,0,1,0,1,0,0,1},
            {0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,1},
            {0,1,0,0,1,0,0,1,0,1,1,1,0,0,1,0,0,1},
            {0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,1},
            {0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,0,0,1},
            {1,1,1,0,1,0,0,1,0,1,0,0,0,0,1,1,1,1},
        };
        // draw "INFO"
        lcd.drawSprite(18, 16, 7, 18, (int*) op_two_data);
        
        int instruct_data[7][75] = {
            {1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
            {1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
            {1,0,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,0},
            {1,1,1,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0},
            {1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,0,0,0,0,1,0,0,0},
            {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,1,0,0,1},
            {1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1},
        };
        // draw instruction
        lcd.drawSprite(5, 38, 7, 75,(int *) instruct_data);
        lcd.refresh();
        
    }
    
    //return value for which menu option is currently selected
    int op = 0;
    if(pos_y == 5){op = 0;}
    else if(pos_y == 16){op = 1;}
    
    //return value for which menu option is currently selected
    return op;

}

// function for drawing year one title screen
void year_one()
{
    lcd.clear();
    int instruct_data[30][78] = {
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    };
    lcd.drawSprite(4, 9, 30, 78,(int *) instruct_data);
    lcd.refresh();
    
    music.level_up(pad);
    
    wait(1.0);
}

// function for setting year one game parameters
void year_one_set()
{
    game_1_speed = 12;
    game_1_cha = 1;
    game_1_r = 5;
    game_2_speed = 1;
    game_2_cha = 1;
    game_2_r = 6;
    game_3_set = 1;
    game_3_time = 0.5;
}

// function for drawing year two title screen
void year_two()
{
    lcd.clear();
    int year_two_data[30][78] = {
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    };
    lcd.drawSprite(4, 9, 30, 78, (int *)year_two_data);
    lcd.refresh();
    
    music.level_up(pad);
    
    wait(1.0);
}

// function for setting year two game parameters
void year_two_set()
{
    game_1_speed = 14;
    game_1_cha = 2;
    game_1_r = 3;
    game_2_speed = 2;
    game_2_cha = 2;
    game_2_r = 5;
    game_3_set = 2;
    game_3_time = 0.4;
}

// function for drawing year three title screen
void year_three()
{
    lcd.clear();
    int year_three_data[30][78] = {
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    };
    lcd.drawSprite(4, 9, 30, 78,(int*) year_three_data);
    lcd.refresh();
    
    music.level_up(pad);
    
    wait(1.0);
}

// function for setting year three game parameters
void year_three_set()
{
    game_1_speed = 14;
    game_1_cha = 3;
    game_1_r = 2;
    game_2_speed = 2;
    game_2_cha = 3;
    game_2_r = 3;
    game_3_set = 3;
    game_3_time = 0.3;
}

// function for displaying the game information
void instruction()
{
    Page currentPage = PAGE_1;
    int fps = 8.0;
    static int instruct_data[] = {
                    1,1,1,1,1,1,1,
                    0,1,1,1,1,1,0,
                    0,0,1,1,1,0,0,
                    0,0,0,1,0,0,0
                };
    
    while(pad.check_event(Gamepad::BACK_PRESSED) == false){
        switch (currentPage) {
            case PAGE_1:
                lcd.clear();
                lcd.printString("PKM Academy",0,0);
                lcd.printString("is an RPG",0,1);
                lcd.printString("which simulates",0,2);
                lcd.printString("the mundane",0,3);
                lcd.printString("life of three",0,4);
                lcd.drawSprite(39, 44, 4, 7, instruct_data);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_2;}
                wait(1.0f/fps);
            break;
            case PAGE_2:
                lcd.clear();
                lcd.printString("uni students.",0,0);
                lcd.printString("Explore and",0,1);
                lcd.printString("conquer all",0,2);
                lcd.printString("challenges uni",0,3);
                lcd.printString("brings forth.",0,4);
                lcd.drawSprite(39, 44, 4, 7, instruct_data);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_3;}
                wait(1.0f/fps);
            break;
            case PAGE_3:
                lcd.clear();
                lcd.printString("Ride with them",0,0);
                lcd.printString("the life of",0,1);
                lcd.printString("frustration,",0,2);
                lcd.printString("anger and ",0,3);
                lcd.printString("despair! ",0,4);
                lcd.printString("Press BACK",12,5);
                lcd.refresh();
                wait(1.0f/fps);
            break;
        }
    }
}

// function for drawing term one title screen
void term_one()
{
    lcd.clear();
    int term_data[30][78] = {
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},

    };
    lcd.drawSprite(4, 9, 30, 78, (int *) term_data);
    lcd.refresh();
    
    music.level_up(pad);
    
    wait(1.0);
}

// function for drawing term two title screen
void term_two()
{
    lcd.clear();
    int term_data[30][78] = {
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
 
    };
    lcd.drawSprite(4, 9, 30, 78,(int *) term_data);
    lcd.refresh();
    
    music.level_up(pad);
    
    wait(1.0);
}

// function for drawing term three title screen
void term_three()
{
    lcd.clear();
    int term_data[30][78] = {
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
   
    };
    lcd.drawSprite(4, 9, 30, 78,(int *) term_data);
    lcd.refresh();
    
    music.level_up(pad);
    
    wait(1.0);
}

// function for drawing mission success screen
void win()
{
    int instruct_data[22][63] = {
        {1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,0,0,1,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},
        {0,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0},
        {1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1},
        {1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1},
        {1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1},
        {1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1},
        {1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1},
        {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0},
    };
    lcd.clear();
    lcd.drawSprite(10, 13, 22, 63, (int *)instruct_data);
    lcd.refresh();
}

// function for drawing mission failure screen
void lose()
{
    int instruct_data[22][58] = {
        {1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0},
        {1,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,0},
        {1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,1,0,0,1,1,0,0,0,0},
        {1,0,0,1,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0},
        {1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0},
        {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
        {0,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0},
        {1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1},
        {1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1},
        {1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1},
        {1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0},
        {1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0},
        {1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0},
        {1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1},
        {1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
        {0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1},
    };
    lcd.clear();
    lcd.drawSprite(10, 13, 22, 58,(int *) instruct_data);
    lcd.refresh();
}

// function for drawing you passed screen
void passed()
{
    int instruct_data[10][83] = {
        {1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
        {1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},
        {1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0},
        {1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1},
        {1,1,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1},
        {0,1,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1},
        {0,0,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1},
        {0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0},
        {0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
        {0,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,0},
    };
    lcd.clear();
    lcd.drawSprite(0, 19, 10, 83, (int *) instruct_data);
    lcd.refresh();
}

// function for drawing you failed screen
void failed()
{
    int instruct_data[10][77] = {
        {1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
        {1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},
        {1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0},
        {1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1},
        {1,1,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1},
        {0,1,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1},
        {0,0,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1},
        {0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,1,0,0,1,1,0,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0},
        {0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
        {0,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,0},
    };
    lcd.clear();
    lcd.drawSprite(4, 19, 10, 77, (int *)instruct_data);
    lcd.refresh();
}

// INTENSE music played in background during exams
void gym()
{
    // bar 1
    pad.tone(NOTE_B4,0.33/2);
    Thread::wait(330/2);
    // to break out of the function
    if (finished == true) {return;}
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_C5,0.33*1.5);
    wait(0.33*1.5);
    // bar 3
    pad.tone(NOTE_B4,0.33/2);
    Thread::wait(330/2);
    if (finished == true) {return;}
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_AS4,0.33*1.5);
    wait(0.33*1.5);
    // bar 5
    pad.tone(NOTE_B4,0.33/2);
    Thread::wait(330/2);
    if (finished == true) {return;}
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_C5,0.33*1.5);
    wait(0.33*1.5);
    // bar 7
    pad.tone(NOTE_B4,0.33/2);
    Thread::wait(330/2);
    if (finished == true) {return;}
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_FS4,0.33/2);
    wait(0.33/2);
    pad.tone(NOTE_B3,0.33/2);
    Thread::wait(330/2);
    if (finished == true) {return;}
    pad.tone(NOTE_CS5,0.33*1.5);
    wait(0.33*1.5);
    
    // Loop while state is true
    while(!finished){
        // bar 8 
        pad.tone(NOTE_DS5,0.33);
        wait(0.33);
        pad.tone(NOTE_CS5,0.33);
        wait(0.33);
        pad.tone(NOTE_DS5,0.33);
        wait(0.33);
        pad.tone(NOTE_E5,0.33/2);
        Thread::wait(330/2);
        // to break out of the function
        if(finished == true) {break;}
        pad.tone(NOTE_FS5,0.33);
        wait(0.33);
        pad.tone(NOTE_E5,0.33);
        wait(0.33);
        pad.tone(NOTE_DS5,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_CS5,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_CS5,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS5,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        // bar 10
        pad.tone(NOTE_A4,0.33*2);
        wait(0.33*2);
        pad.tone(NOTE_CS5,0.33*2);
        Thread::wait(330*2);
        if(finished == true) {break;}
        pad.tone(NOTE_E5,0.33*2);
        wait(0.33*2);
        pad.tone(NOTE_CS5,0.33*2);
        Thread::wait(330*2);
        if(finished == true) {break;}
        // bar 8 
        pad.tone(NOTE_DS5,0.33);
        wait(0.33);
        pad.tone(NOTE_CS5,0.33);
        wait(0.33);
        pad.tone(NOTE_DS5,0.33);
        wait(0.33);
        pad.tone(NOTE_E5,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_FS5,0.33);
        wait(0.33);
        pad.tone(NOTE_E5,0.33);
        wait(0.33);
        pad.tone(NOTE_DS5,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_CS5,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B4,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_CS5,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS5,0.33/2);
        wait(0.33/2);
        // bar 12
        pad.tone(NOTE_CS5,0.33*2);
        wait(0.33*2);
        pad.tone(NOTE_B4,0.33*2);
        Thread::wait(330*2);
        if(finished == true) {break;}
        pad.tone(NOTE_A4,0.33*2);
        wait(0.33*2);
        pad.tone(NOTE_E5,0.33);
        wait(0.33);
        pad.tone(NOTE_E5,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_CS5,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        // bar 14
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        // bar 15
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_FS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_FS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_E4,0.25/2);
        Thread::wait(250/2);
        if(finished == true) {break;}
        pad.tone(NOTE_F4,0.25/2);
        wait(0.33/2);
        // bar 16
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        // bar 17
        pad.tone(NOTE_FS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_FS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_E4,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_D4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_FS4,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_E4,0.33/2);
        wait(0.33/2);
        // bar 18
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_C5,0.33);
        wait(0.33);
        pad.tone(NOTE_A4,0.33);
        wait(0.33);
        pad.tone(NOTE_B4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_C5,0.33);
        wait(0.33);
        pad.tone(NOTE_A4,0.33);
        wait(0.33);
        pad.tone(NOTE_G4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        // bar 19
        pad.tone(NOTE_FS4,0.33*4);
        wait(0.33);
        pad.tone(NOTE_C4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_A3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        pad.tone(NOTE_C4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_A3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_C4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        pad.tone(NOTE_A3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        wait(0.33/4);
        // bar 20
        pad.tone(NOTE_C4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_DS4,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        pad.tone(NOTE_E4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_DS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_D4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_CS4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_C4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        pad.tone(NOTE_AS3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_A3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_GS3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_G3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_FS3,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        pad.tone(NOTE_G3,0.33/4);
        wait(0.33/4);
        // bar 22
        pad.tone(NOTE_GS3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_A3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_AS3,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_B3,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        pad.tone(NOTE_B4,0.33);
        wait(0.33);
        pad.tone(NOTE_C5,0.33);
        wait(0.33);
        pad.tone(NOTE_A4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_B4,0.33);
        wait(0.33);
        pad.tone(NOTE_C5,0.33);
        wait(0.33);
        pad.tone(NOTE_A4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_C5,0.33);
        wait(0.33);
        pad.tone(NOTE_B4,0.33*4);
        wait(0.33*4);
        pad.tone(NOTE_FS5,0.33*4);
        Thread::wait(330*4);
        if(finished == true) {break;}
        // bar 26
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_A4,0.33*3);
        wait(0.33*3);
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_CS5,0.33*3);
        wait(0.33*3);
        pad.tone(NOTE_DS4,0.33);
        wait(0.33);
        pad.tone(NOTE_CS4,0.33);
        wait(0.33);
        pad.tone(NOTE_DS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_E4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_FS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_FS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_FS4,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_DS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_FS4,0.33/2);
        wait(0.33/2);
        // bar 30
        pad.tone(NOTE_B3,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_B3,0.33/2);
        Thread::wait(330/2);
        if(finished == true) {break;}
        pad.tone(NOTE_CS5,0.33*3);
        wait(0.33*3);
        pad.tone(NOTE_A5,0.33*2);
        Thread::wait(330*2);
        if(finished == true) {break;}
        pad.tone(NOTE_E5,0.33*2);
        wait(0.33*2);
        // bar 32
        pad.tone(NOTE_B5,0.33*4);
        wait(0.33);
        pad.tone(NOTE_E4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS4,0.33*1.5);
        wait(0.33*1.5);
        pad.tone(NOTE_FS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_E4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_E4,0.33*1.5);
        wait(0.33*1.5);
        // bar 34
        pad.tone(NOTE_DS4,0.33);
        wait(0.33);
        pad.tone(NOTE_E4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS4,0.33*1.5);
        wait(0.33*1.5);
        pad.tone(NOTE_FS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_A4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_GS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_G4,0.33*1.5);
        wait(0.33/2);
        pad.tone(NOTE_B4,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_DS5,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_FS5,0.33/4);
        wait(0.33/4);
        pad.tone(NOTE_AS5,0.33/4);
        Thread::wait(330/4);
        if(finished == true) {break;}
        // bar 36
        pad.tone(NOTE_B5,0.33*4);
        wait(0.33);
        pad.tone(NOTE_E4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS4,0.33*1.5);
        wait(0.33*1.5);
        pad.tone(NOTE_FS5,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_DS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_CS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_C4,0.33*1.5);
        wait(0.33*1.5);
        // bar 38
        pad.tone(NOTE_A5,0.33*4);
        wait(0.33);
        pad.tone(NOTE_E4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_CS4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_DS4,0.33*1.5);
        wait(0.33*1.5);
        pad.tone(NOTE_CS6,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_A4,0.33/2);
        wait(0.33/2);
        pad.tone(NOTE_GS4,0.33);
        Thread::wait(330);
        if(finished == true) {break;}
        pad.tone(NOTE_A5,0.33*1.5);
        wait(0.33*1.5);
    }
}