#ifndef TWITTER_H
#define TWITTER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Twitter Class
@author Yiu Fai Kwok, University of Leeds
@brief Controls the Twitter in Game_2 
@date 18/04/2019
*/ 
class Twitter
{

public:


    /** Constructor */
    Twitter();
    /** Deconstructor */
    ~Twitter();
    
    /**
     * @brief Initialize the class parameters
     * @param speed (int)
     * @details Initialize the object's position and speed by randomizing a number between 0-7. 
     */
    void init(int speed);
    
    /**
     * @brief Draw the object
     * @details Draw the object according the position _x and _y.
     */
    void draw(N5110 &lcd);
    
    /**
     * @brief Update the object
     * @details Update the new position of the object determined by the speed parameter and initial position
     */
    void update();
    
    // accessors and mutators
    /**
     * @brief Set the object's velocity
     * @param velocity v (Vector2D)
     * @details Set the velocity of the object according to the initial set up from the init(int speed) function
     */
    void set_velocity(Vector2D v);
    
    /**
     * @brief Get the object's velocity
     * @return the current velocity (Vector2D)
     * @details Get the velocity of the object and return as Vector2D
     */
    Vector2D get_velocity();
    
    /**
     * @brief Get the object's position
     * @return the current position (Vector2D)
     * @details Get the position x and y of the object and return as Vector2D
     */
    Vector2D get_pos();
    
    /**
     * @brief Set the object's position
     * @param the value of position p (Vector2D)
     * @details Set the position x and y of the object according to the input p
     */
    void set_pos(Vector2D p);
    
private:
    Vector2D _velocity;
    int _x;
    int _y;
};
#endif