#ifndef GAME_TWO_H
#define GAME_TWO_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Score.h"
#include "FXOS8700CQ.h"
#include "Game_two_cha.h"
#include "Insta.h"
#include "Facebook.h"
#include "Twitter.h"
#include "YouTube.h"

/** Game Two Class
* @brief This class is the game engine for the second mini-game
* @version 2.0
* @author Yiu Fai Kwok
* @date May, 2019
*/

class Game_two
{

public:
    
    /** Constructor */
    Game_two();
    /** Deconstructor */
    ~Game_two();
    
    /**
     * @brief Initialize the class parameters
     * @param speed (int)
     * @param character cha (int)
     * @param ratio r (int)
     * @details Initialize the object speed (speed), the character sprite (cha) and the ratio (r) between how often YouTube icon will appear
     */
    void init(int speed, int cha, int r);
    
    /**
     * @brief Render the lcd screen
     * @param character cha (int)
     * @details Render all objects in game, draw character sprite according to (cha) parameter
     */
    void render(N5110 &lcd, int cha);
    
    /**
     * @brief Read input from FXOS8700CQ
     * @details Read input from accelerometer on the Gamepad to determine direction and magnitude of character's motion
     */
    void read_input(FXOS8700CQ &device);
    
    /**
     * @brief Update the lcd screen
     * @details Update the lcd screen according to the input and current state of the display
     */
    void update(Gamepad &pad, N5110 &lcd, int cha);
    
    /**
     * @brief Draw function for Game 2
     * @param character cha (int)
     * @details Draw function of Game 2 which draw all objects and characters according to the changing variables of positions, alternative sprites and constant (cha)
     */
    void draw(N5110 &lcd, int cha);
    
    /**
     * @brief Get count value
     * @return The current count (int)
     * @details The function returns the number of rounds that have taken place in the game to terminate the game loop once count reaches 6
     */
    int get_count();
    
    /**
     * @brief Update parameter alt
     * @return current value of alt (int)
     * @details The function flips the value of alt to draw the alternative sprite of character to create a running animation
     */
    int update_alt();
    
    /**
     * @brief Intruction 
     * @details The function displays the instructions which describe game rules at the beginning of the game
     */
    void intro(Gamepad &pad, N5110 &lcd);
    
    /**
     * @brief Set count
     * @param count (int)
     * @details The private function set the value for private member _count
     */
    void set_count(int count);
    
private:
    
    /**
     * @brief Check instagram collision
     * @param character cha (int)
     * @details The private function checks if instagram is collided, takes in the character value to determine the size of the hitbox, terminates the game loop and display the gameover screen
     */
    void check_insta_collide(Gamepad &pad, N5110 &lcd, int cha);
    
    /**
     * @brief Check instagram missed
     * @details The private function checks if instagram is missed, reinitiate a new object and increase round counter
     */
    void check_miss_insta(Gamepad &pad);
    
    /**
     * @brief Check facebook collision
     * @param character cha (int)
     * @details The private function checks if facebook is collided, takes in the character value to determine the size of the hitbox, terminates the game loop and display the gameover screen
     */
    void check_face_collide(Gamepad &pad, N5110 &lcd, int cha);
    
    /**
     * @brief Check facebook missed
     * @details The private function checks if facebook is missed, reinitiate a new object and increase round counter
     */
    void check_miss_face(Gamepad &pad);
    
    /**
     * @brief Check twitter collision
     * @param character cha (int)
     * @details The private function checks if twitter is collided, takes in the character value to determine the size of the hitbox, terminates the game loop and display the gameover screen
     */
    void check_twitt_collide(Gamepad &pad, N5110 &lcd, int cha);
    
    /**
     * @brief Check twitter missed
     * @details The private function checks if twitter is missed, reinitiate a new object and increase round counter
     */
    void check_miss_twitt(Gamepad &pad);
    
    /**
     * @brief Check youtube collision
     * @param character cha (int)
     * @details The private function checks if youtube is collided, takes in the character value to determine the size of the hitbox, terminates the game loop and display the gameover screen
     */
    void check_yt_collide(Gamepad &pad, N5110 &lcd, int cha);
    
    /**
     * @brief Check youtube missed
     * @details The private function checks if youtube is missed, reinitiate a new object and increase round counter
     */
    void check_miss_yt(Gamepad &pad);
    
    /**
     * @brief Gameover screen
     * @details The private function initiates the gameover screen and termiate term
     */
    void gameover(N5110 &lcd, Gamepad &pad);
    
    Score music;
    FXOS8700CQ device(I2C* sda, I2C* scl);
    Game_two_cha _p1;
    Insta _insta;
    Facebook _face;
    Twitter _twitt;
    YouTube _yt;
    
    Direction _d;
    float _mag;
    int _speed;
    int _cha;
    int _rand;
    int _count;
    int _alt;
    int _type;
    int _so;

};

#endif