#ifndef MESSAGE_H
#define MESSAGE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Message Class
* @author Yiu Fai Kwok, University of Leeds
* @brief Define the properties of the object message in Game_3 
* @date 23/04/2019
*/ 

class Message
{

public:

    /** Constructor */
    Message();
    /** Deconstructor */
    ~Message();
    
    /**
     * @brief Initialize the class parameters
     * @param the value for position (int)
     * @details Initialize the Message's position
     */
    void init(int position);
    
    /**
     * @brief Draw the Message - oject in Game 3
     * @details Draw the Message on lcd screen
     */
    void draw(N5110 &lcd);
    
    /**
     * @brief Get the position
     * @return the current position (Vector2D)
     * @details Return the position of the Message
     */
    Vector2D get_pos();
    
    /**
     * @brief Set the position
     * @param position p (Vector2D)
     * @details Set the position of the Message
     */
    void set_pos(Vector2D p);
    
private:

    int _x;
    int _y;
    
};
#endif