#ifndef GAME_THREE_H
#define GAME_THREE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Score.h"
#include "Book.h"
#include "Message.h"

/** Game Three Class
* @brief This class is the game engine for the third mini-game
* @version 2.0
* @author Yiu Fai Kwok
* @date May, 2019
*/

class Game_three
{

public:

    /** Constructor */
    Game_three();
    /** Deconstructor */
    ~Game_three();

    /**
     * @brief Initialize the parameters
     * @details Initialize the parameters, count and score in the class
     */
    void init_para();
    
    /**
     * @brief Initialize the randomization
     * @param setting r (int)
     * @details Initialize the setting (r) to set the randomization of the location of books and messages
     */
    void init(Gamepad &pad, int r);
    
    /**
     * @brief Render the lcd screen
     * @param setting r (int)
     * @details Render all objects in game, draw object sprite according to (r) parameter to determine their location
     */
    void render(N5110 &lcd, int r);
    
    /**
     * @brief Draw function for Game 3
     * @param setting r (int)
     * @details Draw function of Game 3 which draw all objects to the changing variables of positions according to constant (r)
     */
    void draw(N5110 &lcd, int r);
    
    /**
     * @brief Read input from Gamepad
     * @details Read input from buttons on the Gamepad to determine which item is being selected for the game
     */
    void read_input(Gamepad &pad);
    
    /**
     * @brief Update the scoring and count
     * @param setting r (int)
     * @details Update the parameters score and count depending on the setting parameter r compared with which input is read from the Gamepad buttons
     */
    void update(Gamepad &pad, int r);
    
    /**
     * @brief Get count value
     * @return The current count (int)
     * @details The function returns the number of rounds that have taken place in the game to terminate the game loop once count reaches 5
     */
    int get_count();
    
    /**
     * @brief Get score value
     * @return The current score (int)
     * @details The function returns the score that player has obtained in the game
     */
    int get_score();
    
    /**
     * @brief Intruction 
     * @details The function displays the instructions which describe game rules at the beginning of the game
     */
    void intro(Gamepad &pad, N5110 &lcd);
    
private:

    void background(N5110 &lcd);
    Score music;
    Book book;
    Message message;
    int _set;
    int _select;
    int _count;
    int _score;

};

#endif