#ifndef OBJECT_H
#define OBJECT_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Object Class
* @author Yiu Fai Kwok, University of Leeds
* @brief Define the properties of the blocks in Game_1 
* @date 25/03/2019
*/ 

class Object
{

public:

    /** Constructor */
    Object();
    /** Deconstructor */
    ~Object();
    
    /**
     * @brief Initialize the class parameters
     * @param speed (int)
     * @details Initialize the object's position and speed
     */
    void init(int speed);
    
    /**
     * @brief Draw the object - block in Game 1
     * @details Draw the block on lcd screen
     */
    void draw(N5110 &lcd);
    
    /**
     * @brief Update the block
     * @details Update the block position 
     */
    void update();
    
    /// accessors and mutators
    /**
     * @brief Set the speed
     * @param speed (int)
     * @details Set the speed of the block according to the level of difficulty determined by year
     */
    void set_velocity(int speed);
    
    /**
     * @brief Get the speed
     * @return the value of speed (int)
     * @details Return the speed of the block
     */
    int get_velocity();
    
    /**
     * @brief Get the position
     * @return the current position (Vector2D)
     * @details Return the position of the block
     */
    Vector2D get_pos();
    
    /**
     * @brief Set the position
     * @param position p (Vector2D)
     * @details Set the position of the block
     */
    void set_pos(Vector2D p);
    
private:
    int _speed;
    int _x;
    int _y;
};
#endif