
#ifndef BULBASAUR_H
#define BULBASAUR_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Bulbasaur Class
* @brief This class contains all information such as sprites and descriptions for the character Bulbasaur
* @version 1.0
* @author Yiu Fai Kwok
* @date Match, 2019
*/

class Bulbasaur
{

public:
    /** Constructor */
    Bulbasaur();
    /** Deconstructor */
    ~Bulbasaur();

    /**
     * @brief Draw the primary sprite
     * @param position x pos_x (int)
     * @param position y pos_y (int)
     * @details Draws the primary evolution of the character, the position will be determined by parameters pos_x and pos_y
     */
    void draw_cha1_sprite(int pos_x,int pos_y,N5110 &lcd);
    
    /**
     * @brief Draw the evolution 1 sprite
     * @details Draws the primary evolution of the character which is displayed when evolving
     */
    void evo_1_sprite(N5110 &lcd);
    
    /**
     * @brief Draw the evolution 2 sprite
     * @details Draws the secondary evolution of the character which is displayed when evolving
     */
    void evo_2_sprite(N5110 &lcd);
    
    /**
     * @brief Draw the name title
     * @param position x x (int)
     * @param position y y (int)
     * @details Draws the name tile of the character, the position will be determined by parameters x and y
     */
    void evo_3_sprite(N5110 &lcd, int x, int y);
    
    /**
     * @brief Draw the congratulation sprite for evolution 1
     * @details Draws the primary evolution of the character which is displayed after evolution
     */
    void evo_1_cong(N5110 &lcd);
    
    /**
     * @brief Draw the congratulation sprite for evolution 2
     * @details Draws the secondary evolution of the character which is displayed after evolution
     */
    void evo_2_cong(N5110 &lcd);
    
    /**
     * @brief Draw the congratulation sprite for evolution 3
     * @details Draws the final evolution of the character which is displayed after evolution
     */
    void evo_3_cong(N5110 &lcd);
    
    /**
     * @brief Display the descrption of the character
     * @details Contain the detail description of the character and the instruction sets to navigate through the manual
     */
    void description(Gamepad &pad, N5110 &lcd);
    
private:

    int _pos_x;
    int _pos_y;
    int _x;
    int _y;

};

#endif