#ifndef START_H
#define START_H

#include "N5110.h"
#include "Gamepad.h"
#include "Charmander.h"
#include "Squirtle.h"
#include "Bulbasaur.h"

/** Start Class
* @brief This class is the starting menu for selecting the character of the game
* @version 1.0
* @author Yiu Fai Kwok
* @date Match, 2019
*/

class Start
{

public:
    /** Constructor */
    Start();
    /** Deconstructor */
    ~Start();

    /**
     * @brief Initialize the class
     * @details Initialize the objects positions.
     */
    void init(Gamepad &pad);
    
    /**
     * @brief Update the objects
     * @details Update the objects on the lcd screen depending on the object being selected and joystick input
     */
    void starter_update(Gamepad &pad);
    
    /**
     * @brief Draw the objects
     * @details Draw the objects, the characters, their alternative sprites and the selection box
     */
    void starter_draw(N5110 &lcd);
    
    /**
     * @brief Updates the selector
     * @return position of selection box (Vector2D)
     * @details Updates the location of the selection box by reading the input from the Gamepad's joystick control
     */
    Vector2D update_select(Gamepad &pad);
    
    /**
     * @brief Update postion of Bulbasaur
     * @return position of Bulbasaur (int)
     * @details Update the position of Bulbasaur when it is selected to create animation 
     */
    int update_animation_b(Gamepad &pad);
    
    /**
     * @brief Update postion of Charmander
     * @return position of Charmander (int)
     * @details Update the position of Charmander when it is selected to create animation 
     */
    int update_animation_c(Gamepad &pad);
    
    /**
     * @brief Update postion of Squirtle
     * @return position of Squirtle (int)
     * @details Update the position of Squirtle when it is selected to create animation 
     */
    int update_animation_s(Gamepad &pad);
    
    /**
     * @brief Update parameter alt
     * @return current value of alt (int)
     * @details Update the parameter alt which determines which position the sprite should be drawn 
     */
    int update_alt();
    
    /**
     * @brief Set postion of selection box
     * @param position of selection box p (Vector2D)
     * @details Function to set the position of the selection box
     */
    void set_pos(Vector2D p);
    
    /**
     * @brief Set postion of the three characters
     * @param position of Charmander pos_cy (int)
     * @param position of Squirtle pos_sy (int)
     * @param position of Bulbasaur pos_by (int)
     * @details Function to set the position of the three characters
     */
    void set_pos_csb(int pos_cy, int pos_sy, int pos_by);
    
    /**
     * @brief Set parameter alt
     * @return the value of alt (int)
     * @details Set the parameter alt which determines which position the sprite should be drawn 
     */
    void set_alt(int alt);
    
    /**
     * @brief Return the Character selected
     * @param the value of position of selection box p (Vector2D)
     * @return current value of select (int)
     * @details Takes in the position of the selection box to determine which character has been selected. Return 0 when Bulbasaur is selected, 1 for Squirtle and 2 for Charmander.
     */
    int get_select(Vector2D p);
    
    /**
     * @brief Display description
     * @param value of select (int)
     * @details Display the descrption of the character being selected when information is being required 
     */
    void intro(int select,Gamepad &pad, N5110 &lcd);
    
private:
    Charmander _c1;
    Squirtle _s1;
    Bulbasaur _b1;
    int _pos_x;
    int _pos_y;
    int _pos_cy;
    int _pos_sy;
    int _pos_by;
    int _alt;
};

#endif