#include "Game_two_cha.h"

Game_two_cha::Game_two_cha()
{

}

Game_two_cha::~Game_two_cha()
{

}

void Game_two_cha::init()
{
    _x = WIDTH/2 - 9;    //x position fixed
    _y = HEIGHT/2 - 9;  //y initial position at mid-point of screen
    _speed = 1;  // default speed
    _score = 0;  // start score from zero
}

void Game_two_cha::draw(N5110 &lcd, int cha)
{
    if(cha == 1){_c1.draw_cha1_sprite(_x, _y, lcd);}
    else if(cha == 2){_c1.draw_cha2_sprite(_x, _y, lcd);}
    else if(cha == 3){_c1.draw_cha3_sprite(_x, _y, lcd);}
}

void Game_two_cha::draw_alt(N5110 &lcd, int cha)
{
    if(cha == 1){_c1.draw_cha1_alt_sprite(_x, _y, lcd);}
    else if(cha == 2){_c1.draw_cha2_alt_sprite(_x, _y, lcd);}
    else if(cha == 3){_c1.draw_cha3_alt_sprite(_x, _y, lcd);}
}

void Game_two_cha::update(Direction d,float mag)
{
    _speed = int(mag*10.0f);  // scale is arbitrary, could be changed in future

    // update y value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == N) {_y-=-_speed*0.7;} 
    else if (d == NE) {_y-=-_speed*0.7; _x+=_speed;}
    else if (d == E) {_x+=_speed;}
    else if (d == SE) {_y+=-_speed*0.7; _x+=_speed;}
    else if (d == S) {_y+=-_speed*0.7;}
    else if (d == SW) {_y+=-_speed*0.7; _x-=_speed;}
    else if (d == W) {_x-=_speed;}
    else if (d == NW) {_y-=-_speed*0.7; _x-=_speed;}

    // check the y origin to ensure that the character doesn't go off screen
    if (_y < 1) {_y = 1;}
    if (_y > HEIGHT - 18) {_y = HEIGHT - 18;}
    if (_x < 1) {_x = 1;}
    if (_x > WIDTH - 18) {_x = WIDTH - 18;}
}

void Game_two_cha::add_score()
{
    _score++;
}

int Game_two_cha::get_score()
{
    return _score;
}

Vector2D Game_two_cha::get_pos()
{
    Vector2D p = {_x,_y};
    return p;   
}