#include "Game_three.h"

Game_three::Game_three()
{

}

Game_three::~Game_three()
{

}

//Enumerate instruction menu from page 1 - 4
enum Page {
    PAGE_1, PAGE_2, PAGE_3, PAGE_4   
};

void Game_three::init_para()
{
    // initiate score and round counter
    _count = 0;
    _score = 0;
}
    
void Game_three::init(Gamepad &pad, int r)
{
    if (r == 1){_set = rand() % 4;} // randomise game setting for 4 possibilities.
    else if (r == 2){_set = rand() % 7;} // randomise game setting for 7 possibilities.
    else if (r == 3){_set = rand() % 4;} // randomise game setting for 4 possibilities.
    
    pad.init_input();
}

void Game_three::render(N5110 &lcd, int r)
{
    lcd.clear();
    draw(lcd, r);
    lcd.refresh();
}

void Game_three::read_input(Gamepad &pad)
{
    if (pad.check_event(Gamepad::A_PRESSED) == true){_select = 0;}
    else if (pad.check_event(Gamepad::B_PRESSED) == true){_select = 1;}
    else if (pad.check_event(Gamepad::X_PRESSED) == true){_select = 2;}
    else if (pad.check_event(Gamepad::Y_PRESSED) == true){_select = 3;}
}

void Game_three::draw(N5110 &lcd, int r)
{
    lcd.clear();
    background(lcd);
    lcd.refresh();
    wait(0.8);
    if (r == 1){
        if (_set == 0){book.init(0); book.draw(lcd); book.init(1); book.draw(lcd); book.init(2); book.draw(lcd); message.init(3); message.draw(lcd);}
        else if (_set == 1){book.init(1); book.draw(lcd); book.init(2); book.draw(lcd);book.init(3); book.draw(lcd);message.init(0); message.draw(lcd);}
        else if (_set == 2){book.init(2); book.draw(lcd); book.init(3); book.draw(lcd);book.init(0); book.draw(lcd);message.init(1); message.draw(lcd);}
        else if (_set == 3){book.init(3); book.draw(lcd); book.init(0); book.draw(lcd); book.init(1); book.draw(lcd); message.init(2); message.draw(lcd);}
    } else if (r == 2){
        if (_set == 0){book.init(0); book.draw(lcd); book.init(1); book.draw(lcd); message.init(2); message.draw(lcd); message.init(3); message.draw(lcd);}
        else if (_set == 1){book.init(1); book.draw(lcd); book.init(2); book.draw(lcd); message.init(3); message.draw(lcd); message.init(0); message.draw(lcd);}
        else if (_set == 2){book.init(2); book.draw(lcd); book.init(3); book.draw(lcd); message.init(0); message.draw(lcd); message.init(1); message.draw(lcd);}
        else if (_set == 3){book.init(3); book.draw(lcd); book.init(0); book.draw(lcd); message.init(1); message.draw(lcd); message.init(2); message.draw(lcd);}
        else if (_set == 4){book.init(1); book.draw(lcd); book.init(3); book.draw(lcd); message.init(0); message.draw(lcd); message.init(2); message.draw(lcd);}
        else if (_set == 5){book.init(0); book.draw(lcd); book.init(2); book.draw(lcd); message.init(1); message.draw(lcd); message.init(3); message.draw(lcd);}
    } else if (r == 3){
        if (_set == 0){message.init(0); message.draw(lcd); message.init(1); message.draw(lcd); message.init(2); message.draw(lcd); book.init(3); book.draw(lcd);}
        else if (_set == 1){message.init(1); message.draw(lcd); message.init(2); message.draw(lcd); message.init(3); message.draw(lcd); book.init(0); book.draw(lcd);}
        else if (_set == 2){message.init(2); message.draw(lcd); message.init(3); message.draw(lcd); message.init(0); message.draw(lcd); book.init(1); book.draw(lcd);}
        else if (_set == 3){message.init(3); message.draw(lcd); message.init(0); message.draw(lcd); message.init(1); message.draw(lcd); book.init(2); book.draw(lcd);}
    }
}

void Game_three::update(Gamepad &pad, int r)
{
    // Check if the correct option has been selected by player, update round and score
    if (r == 1){
        if (_set == 0 && ((_select == 0)|(_select == 1)|(_select == 2))){_count++; _score++; music.coin(pad);}
        else if (_set == 0 && _select == 3){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 1 && ((_select == 1)|(_select == 2)|(_select == 3))){_count++; _score++; music.coin(pad);}
        else if (_set == 1 && _select == 0){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 2 && ((_select == 2)|(_select == 3)|(_select == 0))){_count++; _score++; music.coin(pad);}
        else if (_set == 2 && _select == 1){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 3 && ((_select == 3)|(_select == 1)|(_select == 0))){_count++; _score++; music.coin(pad);}
        else if (_set == 3 && _select == 2){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else {_count++; pad.tone(750.0,0.1); wait(0.1);}
    } else if (r == 2){
        if (_set == 0 && ((_select == 0)|(_select == 1))){_count++; _score++; music.coin(pad);}
        else if (_set == 0 && ((_select == 2)|(_select == 3))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 1 && ((_select == 1)|(_select == 2))){_count++; _score++; music.coin(pad);}
        else if (_set == 1 && ((_select == 3)|(_select == 0))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 2 && ((_select == 2)|(_select == 3))){_count++; _score++; music.coin(pad);}
        else if (_set == 2 && ((_select == 0)|(_select == 1))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 3 && ((_select == 3)|(_select == 0))){_count++; _score++; music.coin(pad);}
        else if (_set == 3 && ((_select == 1)|(_select == 2))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 4 && ((_select == 1)|(_select == 3))){_count++; _score++; music.coin(pad);}
        else if (_set == 4 && ((_select == 0)|(_select == 2))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 5 && ((_select == 0)|(_select == 2))){_count++; _score++; music.coin(pad);}
        else if (_set == 5 && ((_select == 1)|(_select == 3))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else {_count++; pad.tone(750.0,0.1); wait(0.1);}
    } else if (r == 3){
        if (_set == 0 && ((_select == 0)|(_select == 1)|(_select == 2))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 0 && _select == 3){_count++; _score++; music.coin(pad);}
        else if (_set == 1 && ((_select == 1)|(_select == 2)|(_select == 3))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 1 && _select == 0){_count++; _score++; music.coin(pad);}
        else if (_set == 2 && ((_select == 2)|(_select == 3)|(_select == 0))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 2 && _select == 1){_count++; _score++; music.coin(pad);}
        else if (_set == 3 && ((_select == 3)|(_select == 1)|(_select == 0))){_count++; pad.tone(750.0,0.1); wait(0.1);}
        else if (_set == 3 && _select == 2){_count++; _score++; music.coin(pad);}
        else {_count++; pad.tone(750.0,0.1); wait(0.1);}
    }
}

void Game_three::background(N5110 &lcd)
{
    int data [48][84] = {
        {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
        {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
        {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
        {1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1},
        {1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1},
        {0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0},
        {0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0},
        {1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
        {0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0},
        {0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0},
        {0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
        {0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0},
        {0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1},
        {0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0},
        {0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1},
        {1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1},
        {1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
        {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
        {0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},
        {0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
        {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},
        {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
        {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},
    };
    lcd.drawSprite(0, 0, 48, 84, (int*) data);
}

int Game_three::get_count()
{
    int count = _count;
    return count;
}

int Game_three::get_score()
{
    int score = _score;
    return score;
}

void Game_three::intro(Gamepad &pad, N5110 &lcd)
{
    Page currentPage = PAGE_1;
    int fps = 8.0;
    int instruct_data[4][7] = {
        {1,1,1,1,1,1,1},
        {0,1,1,1,1,1,0},
        {0,0,1,1,1,0,0},
        {0,0,0,1,0,0,0},
    };
    
    while(pad.check_event(Gamepad::A_PRESSED) == false){
        switch (currentPage) {
            case PAGE_1:
                lcd.clear();
                lcd.printString("Bulbasaur",0,0);
                lcd.printString("is trying",0,1);
                lcd.printString("to study!",0,2);
                lcd.printString("Stop texting",0,4);
                lcd.drawSprite(39, 44, 4, 7, (int *)instruct_data);
                lcd.refresh();
                if(pad.get_direction() == S){currentPage = PAGE_2;}
                wait(1.0f/fps);
            break;
            case PAGE_2:
                lcd.clear();
                lcd.printString("the girls,",0,0);
                lcd.printString("so he can pass",0,1);
                lcd.printString("the test by",0,2);
                lcd.printString("choosing to",0,3);
                lcd.printString("study!",0,4);
                lcd.printString("Press A",0,5);
                lcd.refresh();
                wait(1.0f/fps);
            break;
        }
    }
}