#ifndef _CAN_H
#define _CAN_H

// 头文件
#include "mbed.h"
#include "math_ops.h"
#include "leg_message.h"
#include "used_leg_message.h"
#include "CAN3.h"
#include "mcp2515.h"

// 宏定义
#define CAN_ID  0x01                                                            // Master CAN ID

#define P_MIN   -25.0f           //-12.5f                                                          // Value Limits
#define P_MAX    25.0f                //12.5f
#define V_MIN   -45.0f
#define V_MAX   45.0f
#define KP_MIN  0.0f
#define KP_MAX  500.0f
#define KD_MIN  0.0f
#define KD_MAX  5.0f
#define T_MIN   -18.0f
#define T_MAX   18.0f                                                           // Value Limits


// 对象外部申明
extern CAN pf_can, df_can;                                                      //设备的外部申明
extern CANMessage pf_rxMsg, df_rxMsg;                                           // 主控收到的CAN消息
extern CANMessage pf_txMsg, df_txMsg;                                               // 主控发送的CAN消息

extern CAN3 df1_can;
extern CANMessage df1_txMsg;
extern CANMessage df1_rxMsg;  


// 函数外部申明
void pack_cmd(CANMessage * msg, joint_control joint);
void PackAll();
void WriteAll();
void unpack_reply(CANMessage msg, ankle_state * ankle);



#endif