#include "mbed.h"
#include "Moving_Average.h"



// Source是不断变化的
float Moving_Average(unsigned int NN, float *FILTER, float Source)
{
    
    float AVER = 0.0f; 
    float SUM = 0; 
    unsigned char i;
    
    
    FILTER[NN] = Source;    // 将接受到的数据放在均值滤波数组的“最后（倒数第2个）”元素里面

    
    // 把第一次进入的 Source 赋值给 FILTER[0] ~ FILTER[N-1]
    if(FILTER[NN+1] == 0)   // FILTER[N+1]等于0，表示第一次进入该函数
    {
        for(i = 0; i < NN; i++)
        {
            FILTER[i] = Source;
        }

        FILTER[NN+1] = 1;   // 设置标记，已经进入过该函数，以后不再全部赋值   
    }
    

    for(i = 0; i < NN; i++)
    {
        FILTER[i] = FILTER[i + 1];
        SUM += FILTER[i];
    }
    
    AVER = SUM / NN;
    SUM = 0;

    return AVER;
}