#ifndef CAN_COM_H
#define CAN_COM_H

#include "structs.h"
#include "user_config.h"
#include "mbed.h"
#include "math_ops.h"

 #define P_MIN -12.5f
 #define P_MAX 12.5f
 #define V_MIN -15.0f
 #define V_MAX 15.0f
 #define KP_MIN 0.0f
 #define KP_MAX 2000.0f
 #define KD_MIN 0.0f
 #define KD_MAX 1000.0f
 #define T_MIN -250.0f
 #define T_MAX 250.0f

void pack_reply(CANMessage *msg, float p, float v, float t);
void unpack_cmd(CANMessage msg, ControllerStruct * controller);


#endif