#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
PwmOut mypwm(p24);
DigitalIn sensorIn(p23, PullUp);

DigitalOut myled(LED1);


//Interrupt is generated every 1ms and count is increased by 1
int flag_01ms=0;
int flag_1ms=0;
int flag_20ms=0;
void counter_100ns()
{
    flag_01ms++;
    flag_1ms++;
    flag_20ms++;
}

int main()
{

    wait(1);

    //Set the 1ms thicker.
    Ticker ticker_100ns;
    ticker_100ns.attach(&counter_100ns,0.0001);

    Timer time;
    time.start();
    float init_time = time.read();
    pc.printf("init_time %.3f sec\n", init_time);
    mypwm.period_us(5);
    mypwm.pulsewidth_us(3);


    float start_time=0.0;
    float end_time=0.0;
    int wait_5s = 10*1000*2;
    int wait_count =0;
    bool is_start=false;
    bool is_end=false;
    int up_count=0;

    bool is_first_rising =false;
    float first_rising_time=0.0;

    while(1) {
        
        if(flag_01ms>=1) {
            flag_01ms=0;
            if(is_start==false) {
                if(sensorIn==0) {
                    up_count++;
                    if (is_first_rising == false) {
                        is_first_rising =true;
                        first_rising_time = time.read();
                    }
                }
            } else {
                if(wait_count>wait_5s) {
                    if(sensorIn==0) {
                        up_count++;
                        if (is_first_rising == false) {
                            is_first_rising =true;
                            first_rising_time = time.read();
                        }
                    }
                } else {
                    wait_count++;
                }
            }
        }
        if(flag_1ms>=10) {
            flag_1ms=0;
            if(up_count>=5 && is_start==false) {
                start_time=first_rising_time;
                pc.printf("start time %.5f sec %.5f\n", start_time-init_time);
                wait_count=0;
                is_first_rising =false;
                first_rising_time = 0.0;
                up_count=0;
                is_start = true;
            } else if(up_count>=5 && is_start==true && is_end==false) {
                end_time=first_rising_time;
                
                pc.printf("end time %.5f sec %.5f \n", end_time-init_time);
                pc.printf("time gap %.5f sec \n", end_time-start_time);
                is_end=true;
            }

        }
        if(flag_20ms>=20*10) {
            flag_20ms=0;
            is_first_rising = false;
            first_rising_time=0.0;
            up_count=0;
        }
        myled = sensorIn;
    }
}
