#include "mbed.h"
#include "Plotting.h"
#include "Motor.h"
#include "HallSensor.h"
#include "SpeedController.h"

//To plot with usb, set as below.
Serial pc(USBTX,USBRX); // Tx, Rx Pin
Plotting plot;

//Set each gpio to see the output of the hall sensor as a led
DigitalOut myled1(LED1);
HallSensor hall (p29);
Motor motor (p23, p24, p25, p26);
PIDController speedController(0.1, 0.5, 0.0, 100.0, 0.0, -1.0, 100.0);//0.05514

//Interrupt is generated every 1ms and count is increased by 1
unsigned int uiFlag_1ms = 0;
unsigned int uiFlag_50ms = 0;

void counter_1ms ()
{
    uiFlag_1ms++;
    uiFlag_50ms++;
}

float myabs(float a)
{
    if(a<0.0) {
        a*=-1.0;
    }
    return a;
}


int main()
{
    wait(1);
    
    //Set the 1ms thicker.
    Ticker ticker_1ms;
    ticker_1ms.attach (&counter_1ms, 0.001);
    
    // for calculating dt
    Timer time;
    time.start();
    
    float curr_speed = 0.0;
    float u_percent= 0.0;
    float setSpeed=0.0;
    
    
    while(1) {
        // Every 1 ms,
        if(uiFlag_1ms >= 1) {
            uiFlag_1ms = 0;
            
            //If A is 0, turn on the LED.
            myled1 = hall.getPinState();
            
            
            // Speed control
            setSpeed = 550.0;
            speedController.setTarget (setSpeed);
            curr_speed = hall.getSpeed_rps();
            u_percent = speedController.update (curr_speed, time.read());
            motor.setSpeed_percent(u_percent, FORWARD);
        }
        
        // Every 50 ms,
        if(uiFlag_50ms >= 50) {
            uiFlag_50ms = 0;
                        
            // clear plotting buffer
            plot.reset ();
            
            // put data to buffer
            plot.put (hall.getSpeed_rps(), 0);
            
            // send buffer
            plot.send (&pc);
        }
    }
}