#include "mbed.h"
#include "DistanceSensor.h"
#include "Plotting.h"
#include "Servo.h"

DistanceSensor pir (p20);
Servo servo (p10);
Serial pc (USBTX, USBRX); // tx, rx
Plotting plot;

//Interrupt is generated every 1ms and degree is increased by 1
unsigned int uiFlag_50ms = 0;
    
void counter_1ms ()
{
    uiFlag_50ms++;
}

// Align servo 
int main()
{
    float degree = 0.0;
    pc.printf("Waiting Request\n");
    servo.update (0.0);
    
    pc.printf("Degree: %f\n", servo.getDegree());
    while(1) {
        char c = pc.getc();
        
        if (c == 'u') degree += 0.5;
        else if (c == 'd') degree -= 0.5;
            
        servo.update (degree);
        degree = servo.getDegree();
        pc.printf("Degree: %f\n", servo.getDegree());
    }
}

//// Plot distance sensor
//int main()
//{
//    wait(1);
//
//    //Set the 1ms thicker.
//    Ticker ticker_1ms;
//    ticker_1ms.attach(&counter_1ms,0.001);
//
//    Timer time;
//    time.start();
//
//    while(1) {
//        // Every 50 ms,
//        if(uiFlag_50ms>=50) {
//            uiFlag_50ms=0;
//            
//            // clear plotting buffer
//            plot.reset();
//            
//            // put data to buffer
//            plot.put(pir.getDistance_cm(),0);
//            
//            // send buffer
//            plot.send(&pc);
////            pc.printf ("Distance %f\r\n", pir.getDistance_cm());
//        }
//    }
//}