#include "mbed.h"
#include "LaneSensor.h"

//To plot with usb, set as below.
Serial pc(USBTX,USBRX); // Tx, Rx Pin

//Set each gpio to see the output of the hall sensor as a led
LaneSensor laneSensor(p11,p12,p13,p14,p15,p16,p17);

//Interrupt is generated every 1ms and count is increased by 1
unsigned int uiFlag_1ms = 0;
unsigned int uiFlag_50ms = 0;

void counter_1ms ()
{
    uiFlag_1ms++;
    uiFlag_50ms++;
}

int main()
{
    wait(1);

    ////Set the 1ms thicker.
    Ticker ticker_1ms;
    ticker_1ms.attach(&counter_1ms, 0.001);
    

    while(1) 
    {
        // Every 50 ms,
        if(uiFlag_50ms >= 50) {
            uiFlag_50ms = 0;
            
            int data = laneSensor.getData();
            float error = laneSensor.getError();
            pc.printf ("data: %d, error: %f \r\n", data, error);
        }
    }
}