#include "mbed.h"
#include "Motor.h"
#include "Plotting.h"
#include "HallSensor.h"


//To plot with usb, set as below.
Serial pc(USBTX,USBRX); // Tx, Rx Pin
Plotting plot;

//Set each gpio to see the output of the hall sensor as a led
DigitalOut myled1(LED1);

HallSensor hall (p29);
Motor motor (p23, p24, p25, p26);

//Interrupt is generated every 1ms and count is increased by 1
unsigned int uiFlag_1ms = 0;
unsigned int uiFlag_50ms = 0;

void counter_1ms ()
{
    uiFlag_1ms++;
    uiFlag_50ms++;
}

int main()
{
    wait(1);
    
    
    ////Set the 1ms thicker.
    Ticker ticker_1ms;
    ticker_1ms.attach(&counter_1ms, 0.001);
    
    //Set the motor to 10%.
    motor.setSpeed_percent(10.0, FORWARD);
    
    while(1) {
        // Every 1 ms,
        if(uiFlag_1ms >= 1) {
            uiFlag_1ms = 0;
            
            //If A is 0, turn on the LED.
            myled1 = hall.getPinState();
        }
        
        // Every 50 ms,
        if(uiFlag_50ms >= 50) {
            uiFlag_50ms = 0;
            
            // clear plotting buffer
            plot.reset ();
            
            // put data to buffer
            plot.put(hall.getSpeed_rps(), 0);
                        
            // send buffer
            plot.send(&pc);
        }
    }
}