#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "QSPI_DISCO_F746NG.h"
#include "EthernetInterface.h"
#include <ctype.h>
#include <math.h>
#define WRITE_READ_ADDR ((uint32_t)0x0050)
#define QSPI_BASE_ADDR ((uint32_t)0x90000000)
#define TIMEOUT_MINUS 600
#define LEN_PACK_9003 18 //длина пакета со временем
#define LEN_PACK_9006 46 //длина пакета с инфой для ПУИ

Thread threadEth; //поток для Eth
Mutex flMut; //мютекс

Serial pc(USBTX, USBRX, 115200); //для отладки
Serial pc1(A4, A5, 2400); //com-порт1
Serial pc2(D1, D0, 2400); //com-порт2

static IWDG_HandleTypeDef IwdgHandle; //для иниц. wdt
static const char* Mask = "255.0.0.0"; //маска подсети
static const char* Gateway = "10.114.48.1"; //шлюз
static char bufX[16] = "XXX.XXX.XXX.XXX";
osThreadId_t idThread2 = 0; //идентификатор потока
Ticker tickerIrqSec, tickerConn, tickWdt; //таймеры событий
LCD_DISCO_F746NG lcd; //экран
TS_DISCO_F746NG ts; //тачпад
TS_StateTypeDef TS_State; //состояние тачпада
QSPI_DISCO_F746NG qspi; //flash_spi
EthernetInterface eth; //сеть
UDPSocket sock9003, sock9006;
SocketAddress sockAddr;
time_t sTime, s1Time, s2Time; //время RTC + для секундомеров
tm t, tmuPui; //структура для времени
short sec1 = 0, sec2 = 0, numStat1 = -1, numStat2 = -1, ind = 0; //секунды, № станций, индекс символа в меню "Сеть"
unsigned int cntRecPack = 0; //кол-во принятых пакетов
uint8_t funcTx = 0;
char checkTh = 0; //счётчик проверки дочернего потока
char readBuf[16], buf[10], buf1[10], buf2[10], bufPc1[3], bufPc2[3], bufSend1[3], bufSend2[3]; //для чтения из флеш, для отображ. RTC,
    //для отображ. секундомеров, буфера для отправки/приёма с ПУИ
char* r; //для копирования в ip
char* ip = "0.0.0.0"; //для хранения ip из flash
bool brightness1 = 0, brightness2 = 0, flTime = 1, flSec1 = 0, flSec2 = 0, flTest = 0, fl1NP = 1, fl2NP = 1,
flWork1 = 0, flWork2 = 0, visible = 1, flEth = 0, flRec1, flRec2, flRecT1 = 0, flRecT2 = 0, flWorkT1 = 0,
flWorkT2 = 0, fl1 = 0, flWdtTh = 0, flCon1 = 0, flCon2 = 0, flNetW = 0, flLight = 0; //флаг яркости, флаги разрешения обновления таймеров,
    //флаг теста, флаги "+"/"-", флаги работы секундомеров, флаг отображ. кнопок, флаг связи с eth, флаги пакетов со станцией,
    //флаги пакета секундомеров, флаги отображ. секундомеров, флаг зависания доч. потока, флаги связи с ПУИ,
    //флаг меню "СЕТЬ", флаг меню "ЯРКОСТЬ"

char* getStation(short); //определение названия станции
void viewStation(short, bool); //вывод названия станции на экран
void logo(); //эмблема нии тм
void setClock(); //установка часов
void viewTimerSec(); //секундомер для путей + RTC
void mainWindow(); //отрисовка главного окна
void settingBut(); //меню настроек
void configWindow(); //окно настройки сети
void drawSelector(); //отрисовка выбора яркости
void drawIP(); //отрисовка эл-ов управления в меню "Сеть"
int defSymbol(uint16_t, uint16_t); //определяем выбранный символ в меню "Сеть"
void viewSymbol(short); //отображаем выбранный символ в меню "Сеть"
void backFunc(); //возврат в основное меню
bool checkIP(const char *); //проверка правильности ввода IP-адреса
void pui1SetTime(int); //отправка времени на ПУИ1
void pui2SetTime(int); //отправка времени на ПУИ2
void sendStatPui1(short); //отправка станции на ПУИ1
void sendStatPui2(short); //отправка станции на ПУИ2
void workConn(); //уст-ка флага отсутствия связи с сервером
void ansPui1(); //ответ от ПУИ1
void ansPui2(); //ответ от ПУИ2
void StartIWDG(int); //watchdog таймер для main()