#include "tank.h"
#include "globals.h"
#include "math.h"
#include "game_synchronizer.h"

extern Game_Synchronizer sync;

// sx is the x-coord of the bottom left corner of the tank
// sy is the y-coord of the same corner
// width is the width of the tank
// height is the height of the tank
Tank::Tank(int sx, int sy, int width, int height, int color) {
    x = sx; y = sy;
    w = width; h = height;
    tank_color = color;
    barrel_theta = PI/4.0;
    barrel_length = w;
    wheel_rad = 2.0;
    draw();
}

void Tank::changeSky(int SKY_COLOR2) {
    SKY_COLOR = SKY_COLOR2;
}

// Return the minimum x-coord of your tank's bounding box.
int Tank::min_x(void) { 
    return x;
}    

// Return the minimum y-coord of your tank's bounding box.
int Tank::min_y(void) {
    return y;
}

// Return the maximum x-coord of your tank's bounding box.
int Tank::max_x(void) { 
    return x + w;
}

// Return the maximum y-coord of your tank's bounding box.
int Tank::max_y(void) {  
    return y + h + wheel_rad;
}

void Tank::barrel_end(int* bx, int* by) {
    // Set the x and y coords of the end of the barrel.
    *bx = x + w/2.0 + barrel_length*cos(barrel_theta);
    *by = y + h + wheel_rad + barrel_length*sin(barrel_theta);
}

void Tank::reposition(int dx, int dy, float dtheta) {
    // Blank out the old tank position, and
    //      Move the tank dx pixels in the x direction.
    //      Move the tank dy pixels in the y direction.
    //      Move the tank barrel by an angle dtheta. Don't allow it to go below parallel.
    // Do collision detection to prevent the tank from hitting things. 
    // (obstacles, side of the screen, other tanks, etc.)
    
    sync.filled_rectangle(min_x(), min_y(), max_x(), max_y(), SKY_COLOR );
    sync.line(x + w/2.0, y+h+wheel_rad, x + w/2.0 + barrel_length*cos(barrel_theta), y+h+wheel_rad + barrel_length*sin(barrel_theta), SKY_COLOR);
    // moving
    if ((x + dx) < 0) {
        // left boundary
        x = 0;
    } else if((x + w + dx) > 128) {
        // right boundary
        x = 128 - w;
    } else if (dx < 0) {
        // moving left
        if ( (sync.pixel_eq(sync.read_pixel(min_x()+dx, min_y()), SKY_COLOR)) &&
             (sync.pixel_eq(sync.read_pixel(min_x()+dx, min_y() + wheel_rad), SKY_COLOR)) ) {
                x = x + dx;
        }
    } else if (dx > 0) {
        // moving right
        if ( (sync.pixel_eq(sync.read_pixel(max_x()+dx, min_y()), SKY_COLOR)) &&
             (sync.pixel_eq(sync.read_pixel(max_x()+dx, min_y() + wheel_rad), SKY_COLOR)) ) {
                x = x + dx;
        }
    }
    // barrel moving
    if ((barrel_theta + (PI/64.0) * dtheta) < 0) {
        // not less than 0
        barrel_theta = 0;
    } else if ((barrel_theta + (PI/64.0) * dtheta) > PI) {
        // not greater than pi
        barrel_theta = PI;
    } else {
        // change barrel theta
        barrel_theta = barrel_theta + (PI/64.0) * dtheta;
    }
    draw();
}


// Example tank draw function. We expect you to get creative on this one!
void Tank::draw() {
    sync.line(x + w/2.0, y+h+wheel_rad, x + w/2.0 + barrel_length*cos(barrel_theta), y+h+wheel_rad + barrel_length*sin(barrel_theta), BLACK);
    sync.filled_rectangle(x, y+wheel_rad, x+w, y+h+wheel_rad, tank_color);
    sync.filled_circle(x+wheel_rad, y+wheel_rad, wheel_rad, BLACK);
    sync.filled_circle(x+w-wheel_rad, y+wheel_rad, wheel_rad, BLACK);
}            