#ifndef BULLET_H__
#define BULLET_H__

#include "tank.h"

#define BULLET_NO_COLLISION -1
#define BULLET_OFF_SCREEN   -2

class Bullet{
    public:
        // sky color
        int SKY_COLOR;
        
        // (x0, y0) is the position of the bullet at the start of its trajectory.
        int x0, y0;
        
        // The components of the bullet's initial velocity.
        float vx0, vy0;
        
        // The current position of the bullet.
        int x, y;
        
        // currernt velocity
        float vx, vy;
        int bounce;
        
        // power up
        int powerups;
        int power;
        
        // How fast is the bullet?
        int speed;
        
        // Keep track of the time since the bullet was shot.
        float time;
        
        // Keep track of whether the bullet is currently in flight.
        // If it is in_flight, update its position. Otherwise, ignore it.
        // Set in_flight when the bullet is shot.
        // Reset in_flight when the bullet hits something.
        bool in_flight;
        
        // Keep a pointer to the tank that shot this bullet. You'll need
        // it to access information about the tank.
        Tank* tank;
        
        // Create a bullet!
        Bullet(Tank* t);
        
        // change sky
        void changeSky(int SKY_COLOR2);
        
        // powerup
        void powerUp(void);
        
        // Shoot the bullet!
        void shoot(void);
        
        // given a time delta, calculate the new (x, y) coords of the bullet.
        void update_position(float dt);
        
        // Once per frame, plug in the time since the last frame.
        // Clear the old bullet and redraw it in the new place.
        // Do collision detection here. Return a code describing what has
        // (or hasn't) been hit.
        int time_step(float dt);    
};

#endif