//
//#include "mbed.h"
//#include "SDFileSystem.h"
//#include "wave_player.h"
//
//
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
//
//AnalogOut DACout(p18);
//
//wave_player waver(&DACout);
//
//int main()
//{
//    FILE *wave_file;
//    printf("\n\n\nHello, wave world!\n");
//    wave_file=fopen("/sd/wavfiles/increasing.wav","r");
//    waver.play(wave_file);
//    fclose(wave_file);
//}


#include "mbed.h"
#include "uLCD_4DGL.h"
#include "queue.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include <string>
#include <vector>
#include <stdio.h>
 
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

AnalogOut DACout(p18);

wave_player waver(&DACout);
 
 // uLCD
 uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin;
 
 // Serial PC
 Serial myPc( USBTX, USBRX );
 
 // Bluetooth
 Serial blue(p9,p10);
 
 // Queue
 Queue myQueue(1,15);
 Queue tempQueue(1,15);
 
 // Shiftbrite LED
 DigitalOut latch(p15);
 DigitalOut enable(p16);
 SPI spi(p11, p12, p13);
 
 // LED code
 void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}
FILE *wave_file;
void speaker(const char* path) {
     wave_file=fopen(path,"r");
     waver.play(wave_file);
     fclose(wave_file);
}

// vector data structure that holds patient info
vector <string> v;

string getCommand(int i) {
     string tempStr = v.at(i);
     int pos = tempStr.find(",");
     return tempStr.substr(0,pos);
}

string getName(int i) {
    string tempStr = v.at(i);
    int pos = tempStr.find(",");
    string command = tempStr.substr(0,pos);
    tempStr.erase(0,pos + 1);
    pos = tempStr.find(",");
    return tempStr.substr(0,pos);
       
}

string getNumber(int i) {
   string tempStr = v.at(i);
   int pos = tempStr.find(",");
   string command = tempStr.substr(0,pos);
   tempStr.erase(0,pos + 1);
   pos = tempStr.find(",");
   string name = tempStr.substr(0,pos);
   tempStr.erase(0,pos + 1);
   return tempStr;   
}

int main() 
 {
    //FILE *wave_file;
    //printf("\n\n\nHello, wave world!\n");
    //wave_file=fopen("/sd/wavfiles/increasing.wav","r");
    //waver.play(wave_file);
    //fclose(wave_file);
    // variables for Serial Port 
    char value[100];
    
    // starting wait time
    int waitTime = 0;
    
    // variables used for getting bluetooth button
    char bnum=0;
    char bhit=0;
    
    // LED variables
    int r=0;
    int g=50;
    int b=0;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(1);
    
    while(1) {
        // Get bluetooth signal
        if (blue.readable()) {
            if (blue.getc()=='!') {
                if (blue.getc()=='B') { //button data packet
                    bnum = blue.getc(); //button number
                    bhit = blue.getc(); //1=hit, 0=release
                    if (bhit=='1')
                        uLCD.cls();
                    uLCD.locate(3,1);
                    //if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                        switch (bnum) {
                            case '1': //number button 1
                                if (bhit=='1') {
                                    //uLCD.printf("Next patient");
                                    waitTime -= 15;
                                    //int patientNum = stoi(v.at(0));
                                    int patientNum = std::atoi(getNumber(0).c_str());
                                    switch (patientNum) {
                                        case 1:
                                            speaker("/sd/wavfiles/1.wav");
                                            break;
                                        case 2:
                                            speaker("/sd/wavfiles/2.wav");
                                            break;
                                        case 3:
                                            speaker("/sd/wavfiles/3.wav");
                                            break;
                                        case 4:
                                            speaker("/sd/wavfiles/4.wav");
                                            break;
                                        case 5:
                                            speaker("/sd/wavfiles/5.wav");
                                            break;
                                        case 6:
                                            speaker("/sd/wavfiles/6.wav");
                                            break;
                                        case 7:
                                            speaker("/sd/wavfiles/7.wav");
                                            break;
                                        case 8:
                                            speaker("/sd/wavfiles/8.wav");
                                            break;
                                        case 9:
                                            speaker("/sd/wavfiles/9.wav");
                                            break;
                                        case 10:
                                            speaker("/sd/wavfiles/10.wav");
                                            break;
                                    }
                                    v.erase(v.begin());
                                    myPc.putc('1');
                                }
                                break;
                            case '2': //number button 2
                                if (bhit=='1') {
                                    //uLCD.printf("Increase wait time");
                                    waitTime += 5;
                                    myPc.putc('2');
                                    speaker("/sd/wavfiles/increasing.wav");
                                }
                                break;
                            case '3': //number button 3
                                if (bhit=='1') {
                                    //uLCD.printf("Decrease wait time");
                                    waitTime -= 5;
                                    myPc.putc('3');
                                    speaker("/sd/wavfiles/decreasing.wav");
                                }
                                break;
                            case '4': //number button 4
                                if (bhit=='1') {
                                    //uLCD.printf("Change LED");
                                    if (r == 0) {
                                        r = 50;
                                        g = 0;
                                        speaker("/sd/wavfiles/busy.wav");
                                    } else {
                                        r = 0;
                                        g = 50;
                                        speaker("/sd/wavfiles/available.wav");
                                    }
                                }
                                break;
                        }
                    //}
                }
            }
        }
        // update LED color
        RGB_LED(r,g,b);
        
        // Display wait time on LCD
        uLCD.locate(0,14);
        if (waitTime < 0)
            waitTime = 0;
        uLCD.printf("Wait Time: %d", waitTime);
        
        // get input from Serial Port
        if (myPc.readable()) {
            // store char[] in value
            myPc.gets(value, 20);
            // convert to string
            string temp (value);
            temp = value;
            // decode information
            // (command, name, number)
            int pos = temp.find(",");
            string command = temp.substr(0,pos);
            // if adding patient
            if (command == "Add") {
                v.push_back(temp);
                waitTime += 15;
            // if removing patient
            } else {
                temp.erase(0,pos + 1);
                pos = temp.find(",");
                string name = temp.substr(0,pos);
                // find patient in vector and remove
                for (int i = 0; i < v.size(); i++) {
                    // TODO
                    // make function that handles this
                    string tempStr = v.at(i);
                    int pos = tempStr.find(",");
                    string command = tempStr.substr(0,pos);
                    tempStr.erase(0,pos + 1);
                    pos = tempStr.find(",");
                    string currentName = tempStr.substr(0,pos);
                    if (currentName == name) {
                        v.erase(v.begin() + i);
                    }
                }
                waitTime -= 15;
            }         
            uLCD.cls();  
        } 
        // update patient list on LCD display
        for (int i = 0; i < v.size(); i++) {
              // TODO
              // make function that handles this
              /*string tempStr = v.at(i);
              int pos = tempStr.find(",");
              string command = tempStr.substr(0,pos);
              tempStr.erase(0,pos + 1);
              pos = tempStr.find(",");
              string name = tempStr.substr(0,pos);
              tempStr.erase(0,pos + 1);
              string number = tempStr;*/
              
              uLCD.locate(0,i*2);
              uLCD.printf("%s", getNumber(i));
              uLCD.locate(3,i*2);
              uLCD.printf("%s", getName(i));
                              
            }
    }
 }