#include "mbed.h"
#include "EasyVR.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Speaker.h"
#include <vector>
#include <string>

//Set up LEDs
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

EasyVR VR(p28, p27);  // tx, rx
Serial pc(USBTX,USBRX);

PwmOut red(p21);
PwmOut blue(p22);
PwmOut green(p23);

PinDetect pb3(p26); // pb for pause

using namespace std;

SDFileSystem sd(p5, p6, p7, p15, "sd"); //SD card
uLCD_4DGL lcd(p9, p10, p8);
DigitalIn sdDetect(p17); // SD Card Detect

AnalogOut DACout(p18); //speaker
wave_player waver(&DACout); //set up wave player library
int pos = 0; // index of the song
int vol = 0; // volume
 
bool playing = false; //variable for pause
vector<string> filenames; //filenames are stored in a vector string
void read_file_names(char *dir) // function that reads in file names from sd cards
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

//incrementing music list
void music_increment (void)
{
    // counts number of songs in the sd card, then increments the index until it reaches the last one, then resets to 0
    int l = filenames.size();
    if (pos < (l-1)) {
        pos++;
    } else if (pos == (l-1)) {
        pos = 0;
    }
    string songname = filenames[pos];
    unsigned index = songname.find(".wav");
    songname = songname.substr(0,index);
    lcd.cls();
    lcd.printf(songname.c_str()); //clears screen then sets the new index song in the lcd display
}


//decrement music list
void decrement_music (void)
{
    //dmoves the index down..from 2nd song to 1st song via changing the index number
    int l = filenames.size();
    if (pos > 0) {
        pos--;
    } else if (pos == 0 ) {
        pos = l-1;
    }
    string songname = filenames[pos];
    unsigned index = songname.find(".wav");
    songname = songname.substr(0,index);
    lcd.cls();
    lcd.printf(songname.c_str());
}


//play-stop music
void play_stop (void)
{
    //this interrupt handler changes the play to pause mode or vice versa
    //this is done using the boolean playing
    if (playing == false) {
        playing = true; 
    } else if (playing == true) {
        lcd.cls();
        playing = false; 
        string songname = filenames[pos];
        unsigned index = songname.find(".wav");
        songname = songname.substr(0,index);
        lcd.printf(songname.c_str());
    }
}

//high volume
void vol_high (void){
    vol = (vol+2) % 16;
}

//low volume
void vol_low (void){
    vol = (vol-2) % 16;
}

void ledDance()
{
    for(int i=0;i<1000;i++)
    {
        red = !green;
        green = !blue;
        blue = !red;
        wait(0.001);
    }
    red = 1;
    green = 1;
    blue = 1;
    
}

int main()
{
    char buffer=0;

    if(VR.awake())                //wake up device - needs more work and a timeout
    {
        myled = 1;
    }
        
    sdDetect.mode(PullUp);
     wait(.1);
     //wait after pulling up the sd card, 
    // read file names into vector of strings
    pb3.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb3.attach_deasserted(&play_stop);
    // Start sampling pb inputs using interrupts
    pb3.setSampleFrequency();

    lcd.cls(); 
    wait(.5);
    sd.disk_initialize();
    read_file_names("/sd/Music");
    
    while (1)
    {
        //while pb3 is low, then we can start playing the song
        while(playing == true) { //we have 2 while loops..one while loop makes sure the music player is always on, the other one is for the song
            string songname = filenames[pos];
            string a = "/sd/Music/";
            string fname = a + songname; //retrieves the file name
            FILE *wave_file; 
            lcd.locate(0,1);
            lcd.printf("Now Playing");
            wave_file = fopen(fname.c_str(),"r"); //opens the music file
            waver.play(wave_file); //plays the music file
            fclose(wave_file);
        }
        
        VR.sendCmd(CMD_RECOG_SI); // Start Recognition
        VR.sendArg(2);            // Use Wordset 2 command 0-5
        
        buffer = VR.recv();       // Receive frequency in byte from easyVR 
        
        if(buffer == CMD_SLEEP)   // If easyVR is sleeping, then activate
        {
            VR.sendCmd(' ');      
        }
        else
        {
            VR.decrypt(&buffer);  // If not sleeping, then continue received message
            pc.printf("%d\n",buffer);
        }
        
        // if command is taken by easyVR, the LED4 will toggle
        if (buffer==1) {red = 0; green = 0; blue = 1;music_increment();}   // right: move song
        if (buffer==0) {red = 1; green = 0; blue = 0;decrement_music();}   // left: move song
        if (buffer==4) {myled4=!myled4;ledDance();play_stop();}      // foward: play music
        if (buffer==2) {red = 1; green = 1; blue = 0;vol_high();}   // up: volume high
        if (buffer==3) {red = 0; green = 1; blue = 1;vol_low();}   // down: volum low
        wait(0.1);
    }


}
