#pragma once
#include "EasyVR.h"

EasyVR::EasyVR(PinName tx,PinName rx):_easyVR(tx,rx)
{
}

EasyVR::~EasyVR()
{
}

void EasyVR::sendCmd(uint8_t c)
{
    _easyVR.putc(c);
    wait(0.001);
}

void EasyVR::sendArg(int8_t c)
{
    _easyVR.putc(c + ARG_ZERO);
    wait(0.001);
}

int8_t EasyVR::recv(int8_t time)
{
    while(!_easyVR.readable() && time != 0)
    {
        if(time>0)
        time--;
        wait(0.001);
    }
    return _easyVR.getc();
}

void EasyVR::decrypt(char* arg)
{
    *arg = *arg - ARG_ZERO;
}

bool EasyVR::awake(int timeOut)
{
    bool isAwake=0;

    while (timeOut>0)
    {
        _easyVR.putc(CMD_BREAK);
        if(_easyVR.getc()==CMD_TIMEOUT)
        {
            isAwake = 1;
        }

        if(timeOut>0)
        {
            timeOut--;
        }
        wait(0.001);
    }
    return isAwake;
}