#include "mbed.h"
#include "Akene.h"
#include "SerialGPS.h"
#include "math.h"
 
Serial pc(USBTX, USBRX); // tx, rx
SerialGPS gps(PA_9,PA_10);  // tx, rx

void cbfunc_log(char *s) {

}

/**
 * A callback function for GGA.
 *
 * GGA - Global Positioning System Fixed Data.
 */
 float latitude = 0.0;
 float longitude = 0.0;
 int flag = 0;
void cbfunc_gga(SerialGPS::gps_gga_t *p) {

        pc.printf("%02d:%02d:%02d(P%d,S%d)\r\n", p->hour, p->min, p->sec, p->position_fix, p->satellites_used);

        pc.printf("%c=%10.4f\r\n", p->ns, p->latitude);

        pc.printf("%c=%10.4f\r\n", p->ew, p->longitude);
    
        latitude = (float) p->latitude;
        longitude = (float) p->longitude;
        flag = 1;
        
}

void cbfunc_gsa(SerialGPS::gps_gsa_t *p) {

        pc.printf("SEL:%c FIX:%d\r\n", p->selmode, p->fix);
  
}
void cbfunc_gsv(SerialGPS::gps_gsv_t *p) {
 
        pc.printf("Satellites:%2d\r\n", p->satcnt);

}
void cbfunc_rmc(SerialGPS::gps_rmc_t *p) {

        pc.printf("%02d:%02d:%02d(%c)\r\n", p->hour, p->min, p->sec, p->status);

}

/**
 * Entry point.
 */

int main() {
    
     pc.baud(9600);
    pc.printf("beginn\n\r");
    // GPS set 
    wait(0.5);
    SerialGPS::gps_callback_t cb;
    cb.cbfunc_log = cbfunc_log;
    cb.cbfunc_gga = cbfunc_gga;
    cb.cbfunc_gsa = cbfunc_gsa;
    cb.cbfunc_gsv = cbfunc_gsv;
    cb.cbfunc_rmc = cbfunc_rmc;
    gps.attach(&cb);
    
     
     //Wait for proper longitude and latitude
     while( flag == 0) {
       gps.processing();
        //wait(0.5);
    }


    //sigfox
    char tmp[8];
    printf("\ntest envoie sigfox\n");

    // Init modem
    Akene.begin();
    printf("begin ok");
    
    
    while (!Akene.isReady()) {
        printf("Modem not ready");
        wait(1);
    }

    // DATA ENCODING :

    // Mettre latitude à envoyer dans :
    float float_variable0 = longitude;
    char bytes_array0[4];
    // Mettre longitude à envoyer dans : 
    float float_variable1 = latitude;
    char bytes_array1[4];
    
    *((float *)bytes_array0) = float_variable0;
    *((float *)bytes_array1) = float_variable1;   
    
    char bytes_array_final [8];
    int i;
    for ( i =0;i<8;i++){
        if (i<4){
             bytes_array_final[i]=bytes_array0[i];   
            
        }
        else {
            bytes_array_final[i]=bytes_array1[i-4];    
        }   
    }
    
    // DATA SENDING : 
    printf("Sending");

     Akene.send(&bytes_array_final,sizeof(bytes_array_final));
    wait(10);
    
    
}
