#include "mbed.h"
#include "QEI.h"
#include "math.h"
#include "functions.h"

// Digital systems
DigitalOut led(LED_RED);                            // Notification LED once a sequential phase has ended
DigitalOut LedR(D0);                                // Feedback red lights
DigitalOut LedB(D1);                                // Feedback blue lights
DigitalOut LedG(D9);                                // Feedback green lights
DigitalOut magneet(D2);                             // Switching signal of the magnet
DigitalOut Direction(D4);                           // Direction engine: Motor left/right
DigitalOut Direction2(D7);                          // Direction engine: Motor front/back

// PWM systems
PwmOut PowerMotor(D5);                              // Diferent engine controls: Motor left/right
PwmOut PowerMotor2(D6);                             // Diferent engine controls: Motor front/back
PwmOut PowerServo(D3);                              // Diferent engine controls: Servo

// Analog systems
AnalogIn    ButtonRight(A1);                        // Right arm idea, button input
AnalogIn    ButtonLeft(A0);                         // Left arm idea, button input
AnalogIn    StopSystemA(A2);
AnalogIn    StopSystemB(A3);

// Other systems
QEI EncoderMotorLR(D13,D12,NC,64,QEI::X4_ENCODING); // Encoder motor left/right
QEI EncoderMotorFB(D11,D10,NC,64,QEI::X4_ENCODING); // Encoder motor front/back
Ticker      MotorWrite;                             // Ticker to write information in fixed intervals to the motors
Ticker      Sender;                                 // Ticker to send graph data in fixed intervals to the pc
Ticker      sample_timer;                           // Ticker to measure EMG data in fixed intervals
Timer       timer;                                  // Timer to check if the error is small enough for a certain time
Timer       spierrustrechts;                        // Timer to reduce repeatition in EMG input
Timer       spierrustlinks;                         // Timer to reduce repeatition in EMG input
Timer       Safety;

// changeable parameters
double margin=15;                                   // Distance to the ends of the rail in mm
double upperlimitLR=570;                            // maximum length of the rail
double speed_driving=0.15;                          // Speed the first motor drives at when controlling manual
double Speed_driving_back=0.2;                      // Speed the first motor drives when going to start
double speed_driving2=0.2;                          // Speed the second motor drives when controlling manual
double Speed_driving_back2=0.2;                     // Speed the second motor drives when going to start
const double Kp = 0.2;                              // Parameter P controller to set motor to the middle of the chess squares
const double Kd = 10;                               // Parameter D controller to set motor to the middle of the chess squares
const double Ki = 0.2;                              // Parameter i controller to set motor to the middle of the chess squares
const double Factor=2.363636363636363;              // Factor between gears
int Right=1;                                        // Boolean for the direction of the motor
int Left=0;                                         // Boolean for the direction of the motor
// filter parameters
double v1 = 0, v2 = 0, u = 0,va1=0,va2=0,u2=0;      // Input variables for the filters
double vNF1 = 0,vNF2 = 0, vNF3 = 0, vNF4 = 0, vNF5 = 0, vNF6 = 0,vaNF1 = 0,vaNF2 = 0, vaNF3 = 0, vaNF4 = 0, vaNF5 = 0, vaNF6 = 0;
// parameters motor controller
bool Excecute = false;                              // Boolean to put the robot in the middle of the chess area in x(left/right) direction
bool Excecute2 = false;                             // Boolean to put the robot in waiting for the y input forward/backward
bool Excecute3 = false;                             // Boolean to put the robot in the middle of the chess area in y(forward backward) direction
bool Home = true;                                   // Return to starting position
bool CheckRightEMG=false;                           // A control system in the robot that the robot can't save data or move in the oposite direction
bool CheckLeftEMG=false;                            // A control system in the robot that the robot can't save data or move in the oposite direction
bool SignalRight=false;                             // Boolean which sets to true if a signal is given on the right arm
bool SignalLeft=false;                              // Boolean which sets to true if a signal is given on the left arm
bool Correct1=false;                                // Boolean which sets to true if the robot is at start in x direction
bool Correct2=false;                                // Boolean which sets to true if the robot is at start in y direction
const double Fs=100;                                // Frequency that information is writen to the motors
const double twopi = 6.2831853071795;               // definition of 2pi
double Rotatie=0;                                   // angle of the motor in x direction in radials
double Goal = 0;                                    // initial goal in x direction this is zero to stop the robot from starting to drive
double Rotatie2=0;                                  // angle of the motor in y direction in radials
double Goal2 = 0;                                   // initial goal in y direction this is zero to stop the robot from starting to drive
double Error = 0;                                   // Definition of the proportional error for the x direction
double Errord = 0;                                  // Definition of the derivative error for the x direction
double Errori = 0;                                  // Definition of the integratal error for the x direction
double Errorp = 0;                                  // Definition of the previous error in x direction used to calculate the derivative error and the integral error
double Error2 = 0;                                  // Definition of the proportional error for the y direction
double Errord2 = 0;                                 // Definition of the derivative error for the y direction
double Errori2 = 0;                                 // Definition of the integratal error for the y direction
double Errorp2 = 0;                                 // Definition of the previous error in y direction used to calculate the derivative error and the integral error
double speed = 0;                                   // Speed of motor in x direction(left/right)
double speed2=0;                                    // Speed of motor in y direction(front/back)
int NumberTimesPressed=1;                           // Parameter to help the control
int NumberTimesPressed2=1;
int NumberTimesPakOp=0;
// Declaration
double buffTot;                                     // Declaration for the moving average of the right arm EMG signal
double buffaTot;                                    // Declaration for the moving average of the left arm EMG signal
int Pulses;                                         // Declaration for the variable to know the number of pulses from the encoder in x direction
int Pulses2;                                        // Declaration for the variable to know the number of pulses from the encoder in y direction
float Vakjex;                                       // Used to calculate in which area the robot is to put it in the middle in x direction
int VakjexNatural;                                  // ""
int Vakjexround;                                    // ""
float Vakjey;                                       // Used to calculate in which area the robot is to put it in the middle in y direction
int VakjeyNatural;                                  // ""
int Vakjeyround;                                    // ""
double ValueStopSystemA;                            // Measurement stop x direction
double ValueStopSystemB;                            // Measurement stop y direction

// functions
void sample()                                       // Function which collects and filters the EMG inputs at 500Hz
{
    if(ButtonRight.read()>0.8f&&spierrustrechts.read()<=0.000001f) {   // Checking if there is a pulse in the right arm
        spierrustrechts.start();
        SignalRight=true;
    }
    if (spierrustrechts.read()>=0.7f) {               // Preventing that from a single pulse is being stored once not used and that a single push doens't create multiple pulses
        spierrustrechts.stop();
        spierrustrechts.reset();
        SignalRight=false;
    }
    if(ButtonLeft.read()>0.8&&spierrustlinks.read()<=0.000001f) {   // Checking  if there is a pulse in the left arm
        spierrustlinks.start();
        SignalLeft=true;
    }
    if (spierrustlinks.read()>=0.7f) {                      // Preventing that from a single pulse is being stored once not used and that a single push doens't create multiple pulses
        spierrustlinks.stop();
        spierrustlinks.reset();
        SignalLeft=false;
    }
}

void PakOp()                                        // Function which makes the servo turn and changes the state of the electromagnet
{
    PowerServo.write(0.1);
    wait(1);
    PowerServo.write(0.25);                         // Servo moves to -90 degree
    wait(0.5);
    magneet=!magneet;                               // Electromagnet changes state (on/off)
    wait(3);
    PowerServo.write(0.1);
    wait(0.5);
    PowerServo.write(0.035);                        // Servo moves to 90 degrees
    wait(1);
    NumberTimesPakOp=NumberTimesPakOp+1;            // Number to know if there is a even number of state changes (Pick up/Put down)
}

void MotorSet()
{
    if (Excecute||Excecute3) {                      // Situation that the PID controller should be on
        Errord = (Error-Errorp)/Fs;                 // Calculating the D part of the controller first motor
        Errorp = Error;                             // Setting the previous Error of the first motor
        Errord2 = (Error2-Errorp2)/Fs;              // Calculating the D part of the controller second motor
        Errorp2 = Error2;                           // Setting the previous Error of the second motor
        if (fabs(Error) <= 0.5) {                   // Once the I part of the controller should start working
            Errori = Errori + Error*1/Fs;           // Calculating the I part of the controller
        } else {
            Errori = 0;                             // If the I part shouldn't be active this Error is set to 0
        }
        if (fabs(Error2)<=0.5) {                    // Same but other direction
            Errori2=Errori2+Error2/Fs;
        } else {
            Errori2=0;
        }
        speed=Kp*Error + Kd*Errord + Ki*Errori;     // Calculating the output of the controller with the constants for each error
        speed2=Kp*Error2+Kd*Errord2+Ki*Errori2;     // Same but other motor
        if (Error>=0) {                             // Chosing the direction of the first motor
            Direction=1;
        } else {
            Direction=0;
        }
        if (Error2>=0) {                            // Chosing the direction of the second motor
            Direction2=1;
        } else {
            Direction2=0;
        }
    }
    //if (CheckRightEMG||CheckLeftEMG) {              // Safeguard that the robot can't leave the rail with the first motor
//        Safety.start();
//        if(Safety.read()>=0.1) {
//            if (ValueStopSystemA>=0.8||Rotatie<=-18) {
//                Excecute=true;
//                CheckRightEMG=false;
//                CheckLeftEMG=false;
//                NumberTimesPressed=1;
//                speed=0;
//            }
//            if (ValueStopSystemB>=0.8||Rotatie2<=-23.33) {
//                Excecute3=true;
//                CheckRightEMG=false;
//                CheckLeftEMG=false;
//                NumberTimesPressed2=1;
//                speed2=0;
//            }
//        }
//    }
//    if (Home) {
//        Safety.stop();
//        Safety.reset();
//    }
    PowerMotor.write(fabs(speed));                  // Writing the speed to the motors
    PowerMotor2.write(fabs(speed2));
}
void Measurements()                                 // Measurements
{
    ValueStopSystemA=StopSystemA.read();
    ValueStopSystemB=StopSystemB.read();
    Pulses = EncoderMotorLR.getPulses();            // Pulses of the encoder first motor in X4
    Rotatie = (Pulses*twopi)/8400;                  // Angle of the first motor
    Pulses2=EncoderMotorFB.getPulses();             // Pulses of the encoder second motor in X4
    Rotatie2=(Pulses2*twopi)/8400;                  // Angle of the second motor
}
int main()
{
    LedR.write(0),LedB.write(0),LedG.write(0);      // Making sure all the feedback lights are off
    PowerServo.period_ms(20);                       // Setting the PWM signal to the correct period for the servo motor
    magneet.write(0);                               // Making sure the Magnet is off in the beginning
    led.write(1);                                   // Making sure the LED is off in the beginning
    PowerMotor.write(0);                            // Making sure the first motor is off
    PowerMotor2.write(0);                           // Making sure the second motor is off
    Sender.attach(Measurements,0.5/Fs);             // Calling the Measurements function in fixed intervals at twice the frequency as the motors get writen
    MotorWrite.attach(MotorSet,1/Fs);               // Writing data to the motors at a fixed interval
    sample_timer.attach(&sample, 0.002);            // Looking for EMG inputs at a fixed interval
    wait(1);                                        // Wait a moment to skip the first peak of the EMG signal due to opening of the analog ports
    while (true) {
        LedR.write(0),LedB.write(0),LedG.write(1);  // Turning on the feedback light that the client can control the device
        // move input
        if (SignalRight && Rotatie*11*Factor<=-margin) {    // Checking and locking the correct arm side for the movement of the robot
            LedR.write(1),LedB.write(0),LedG.write(1);      // Turning on the feedback light that the robot should be moving
            CheckRightEMG=true;
            NumberTimesPressed=NumberTimesPressed+1;
            SignalRight=false;
            wait(0.5);
            speed=speed_driving;
            Direction=Right;
        }
        while (CheckRightEMG) {                         // Keeping the right arm signal as only nessecary signal
            if(SignalRight) {
                NumberTimesPressed=NumberTimesPressed+1;
                SignalRight=false;
                speed=speed_driving;
                Direction=Right;

            }
            if (NumberTimesPressed%3==0) {              // If moved and stopped then continue to next step, remove lock on a single signal
                Excecute=true;
                CheckRightEMG=false;
                speed=0;
                NumberTimesPressed=NumberTimesPressed+1;
            }
        }
        if(SignalLeft) {                                // Checking left arm signal and locking on only the left arm signal if this is activated once
            LedR.write(1),LedB.write(0),LedG.write(1);  // Turning on the feedback light that the robot should be moving
            CheckLeftEMG=true;
            NumberTimesPressed2=NumberTimesPressed2+1;
            SignalLeft=false;
            wait(0.5);
            speed=speed_driving;
            Direction=Left;
        }
        while (CheckLeftEMG) {                          // Locks on left arm signal
            if(SignalLeft && Rotatie*11*Factor>=-upperlimitLR+margin) {
                NumberTimesPressed2=NumberTimesPressed2+1;
                SignalLeft=false;
                speed=speed_driving;
                Direction=Left;
            }
            if(NumberTimesPressed2%3==0) {              // If moved and stopped then continue to next stop, remove lock on a single signal
                Excecute=true;
                CheckLeftEMG=false;
                speed=0;
                NumberTimesPressed2=NumberTimesPressed2+1;
            }
        }
        if (Excecute) {                                 // Determine the location of the middle of selected field
            LedR.write(1),LedB.write(0),LedG.write(0);  // Turning on the feedback lights that the robot is controlling itself
            Vakjex=Rotatie/1.7964285714285714285714285714286; //mapping constant
            VakjexNatural=Vakjex;
            if (Vakjex-VakjexNatural>=0.5f) {
                Vakjexround=Vakjex+1;
            } else if(Vakjex-VakjexNatural<=-0.5f) {
                Vakjexround=Vakjex-1;
            } else if(Vakjex-VakjexNatural>-0.5f&&Vakjex-VakjexNatural<0.5f) {
                Vakjexround=Vakjex;
            }
            Goal=Vakjexround*1.7964285714285714285714285714286;
        }
        while (Excecute ) {                             // Moving to determined location
            Error = Goal-Rotatie;
            if (fabs(Error)<=0.05) {
                timer.start();
            } else {
                timer.stop();
                timer.reset();
            }
            if (timer.read() >= 1) {
                Excecute=false;
                Excecute2 = true;
                Error = 0;
                Errori = 0;
                Errord = 0;
                speed=0;
                timer.stop();
                timer.reset();
            }
        }
        // move y direction
        while (Excecute2) {
            LedR.write(0),LedB.write(0),LedG.write(1);      // Turning on the feedback light that the client can control the device
            led.write(0);
            if(SignalRight) {
                LedR.write(1),LedB.write(0),LedG.write(1);  // Turning on the feedback light that the robot should be moving
                CheckRightEMG=true;
                NumberTimesPressed=NumberTimesPressed+1;
                SignalRight=false;
                wait(0.5);
                speed2=speed_driving2;
                Direction2=Left;
            }
            while (CheckRightEMG) {
                if(SignalRight) {
                    NumberTimesPressed=NumberTimesPressed+1;
                    SignalRight=false;
                    speed2=speed_driving2;
                    Direction2=Left;
                }
                if (NumberTimesPressed%3==0) {
                    Excecute3=true;
                    Excecute2=false;
                    CheckRightEMG=false;
                    led.write(1);
                    speed2=0;
                    NumberTimesPressed=NumberTimesPressed+1;
                }
            }
            if(SignalLeft) {
                LedR.write(1),LedB.write(0),LedG.write(1);  // Turning on the feedback light that the robot should be moving
                CheckLeftEMG=true;
                NumberTimesPressed2=NumberTimesPressed2+1;
                SignalLeft=false;
                wait(0.5);
                speed2=speed_driving2;
                Direction2=Right;
            }
            while (CheckLeftEMG) {
                if(SignalLeft) {
                    NumberTimesPressed2=NumberTimesPressed2+1;
                    SignalLeft=false;
                    speed2=speed_driving2;
                    Direction2=Right;
                }
                if(NumberTimesPressed2%3==0) {
                    Excecute3=true;
                    Excecute2=false;
                    CheckLeftEMG=false;
                    led.write(1);
                    speed2=0;
                    NumberTimesPressed2=NumberTimesPressed2+1;
                }
            }
            // move to the middle of the field
            if (Excecute3) {
                LedR.write(1),LedB.write(0),LedG.write(0);  // Turning on the feedback lights that the robot is controlling itself
                Vakjey=Rotatie2/3.3333333;      // mapping constant
                VakjeyNatural=Vakjey;
                if (Vakjey-VakjeyNatural>=0.5f) {
                    Vakjeyround=Vakjey+1;
                } else if(Vakjey-VakjeyNatural<=-0.5f) {
                    Vakjeyround=Vakjey-1;
                } else {
                    Vakjeyround=Vakjey;
                }
                Goal2=Vakjeyround*3.3333333;
            }

        }
        while (Excecute3 ) {
            Error2 = Goal2-Rotatie2;
            if (fabs(Error2)<=0.05) {
                timer.start();
            } else {
                timer.stop();
                timer.reset();
            }
            if (timer.read() >= 1) {
                Excecute3=false;
                Error2 = 0;
                Errori2 = 0;
                Errord2 = 0;
                speed2=0;
                timer.stop();
                timer.reset();
                PakOp();
            }
        }
        if (NumberTimesPakOp%3==0) {
            Home=true;
        }
        while (Home) {
            LedR.write(1),LedB.write(0),LedG.write(0);      // Turning on the feedback lights that the robot is controlling itself
            if (!Correct1) {
                if (ValueStopSystemA<0.5) {
                    Direction=Right;
                    speed=Speed_driving_back;
                }
                if (ValueStopSystemA>=0.8) {
                    speed=0;
                    Correct1=true;
                    EncoderMotorLR.reset();
                }
            }
            if(!Correct2) {
                if (ValueStopSystemB<0.5) {
                    Direction2=Right;
                    speed2=Speed_driving_back2;
                }
                if (ValueStopSystemB>=0.8) {
                    speed2=0;
                    Correct2=true;
                    EncoderMotorFB.reset();
                }
            }
            if (Correct1&&Correct2) {
                Home=false;
                Correct1=false;
                Correct2=false;
                NumberTimesPakOp=NumberTimesPakOp+1;
            }
        }
    }
}