#include "mbed.h"
#include "QEI.h"
#include "math.h"
#include "HIDScope.h"

DigitalOut Direction(D4); //1 = CCW - 0 = CW
DigitalOut Direction2(D7);
PwmOut PowerMotor(D5); //van 0 tot 1
PwmOut PowerMotor2(D6);
PwmOut PowerServo(D3);
DigitalIn Button(D9);
DigitalIn Button2(D2);
AnalogIn PotMeter(A1);
QEI Encoder(D13,D12,NC,32,QEI::X2_ENCODING); //Encoder
QEI Encoder2(D11,D10,NC,32,QEI::X2_ENCODING); //Encoder
Serial pc(USBTX, USBRX);
Ticker MotorWrite;
Ticker Sender;
Timer timer;
HIDScope scope(4);
DigitalOut led(LED_RED);
DigitalOut led2(LED_GREEN);


double z=0; //initiele waarde potmeter
const double twopi = 6.2831853071795;
int Pulses;
int Pulses2;
int NumberTimesPressed=1;
int NumberTimesPressed2=1;
int NumberTimesPakOp=1;
float Vakjex;
int VakjexNatural;
int Vakjexround;
float Vakjey;
int VakjeyNatural;
int Vakjeyround;
double Rotatie=0; //aantal graden dat de motor is gedraaid
double Goal = 0; //initele waarde goal waar de motor naar toe moet, dit wordt gedaan
double Rotatie2=0; //aantal graden dat de motor is gedraaid
double Goal2 = 0; //initele waarde goal waar de motor naar toe moet, dit wordt gedaan
double Error = 0;
double Errord = 0;
double Errori = 0;
double Errorp = 0;
double Error2 = 0;
double Errord2 = 0;
double Errori2 = 0;
double Errorp2 = 0;
double Servo=0.1;
const double Kp = 0.2; //Moet berekend worden aan de hand van Control concept slides
const double Kd = 10;
const double Ki = 0.2;
double v = 0; //snelheid van de motor (0-0.1)
double v2=0;
double upperlimit; //max aantal rotaties
bool Excecute = false;
bool Excecute2 = false;
bool Excecute3 = false;
bool Excecute4 = false;
bool CheckButton1=false;
bool CheckButton2=false;
const double Fs=100;

double n = 3;
void PakOp()
{
    PowerServo.write(0.25);
    wait(1);
    led2=!led2;
    wait(1);
    PowerServo.write(0.035);
    wait(2);
    NumberTimesPakOp=NumberTimesPakOp+1;
}

void MotorSet()
{
    if (Excecute||Excecute3||Excecute4) {
        Errord = (Error-Errorp)/Fs;
        Errorp = Error;
        Errord2 = (Error2-Errorp2)/Fs;
        Errorp2 = Error2;
        if (fabs(Error) <= 0.5) {
            Errori = Errori + Error*1/Fs;
        } else {
            Errori = 0;
        }
        if (fabs(Error2)<=0.5) {
            Errori2=Errori2+Error2/Fs;
        } else {
            Errori2=0;
        }
        v=Kp*Error + Kd*Errord + Ki*Errori;
        v2=Kp*Error2+Kd*Errord2+Ki*Errori2;
        if (Error>=0) {
            Direction=1;
        } else {
            Direction=0;
        }
        if (Error2>=0) {
            Direction2=1;
        } else {
            Direction2=0;
        }
    }
    PowerMotor.write(fabs(v));
    PowerMotor2.write(fabs(v2));
}
void Send()
{
    Pulses = Encoder.getPulses();
    Rotatie = (Pulses*twopi)/4200;
    Pulses2=Encoder2.getPulses();
    Rotatie2=(Pulses2*twopi)/4200;
    scope.set(0,Goal);
    scope.set(1,Rotatie);
    scope.set(2,Goal2);
    scope.set(3,Rotatie2);
    scope.send();
}
int main()
{
    PowerServo.period_ms(20);
    led.write(1);
    led2.write(1);
    upperlimit = n*twopi;
    pc.baud(115200);
    PowerMotor.write(0);
    Sender.attach(Send,0.5/Fs);
    MotorWrite.attach(MotorSet,1/Fs); // Deze ticker moet de waarde uitlezen van de PotMeter Fs keer per seconde
    while (true) {
        // move input
        if (Button == 0) {
            CheckButton1=true;
            wait(0.5);
            v=0.05;
            Direction=1;
            NumberTimesPressed=NumberTimesPressed+1;
        }
        while (CheckButton1) {
            if (Button == 0) {
                wait(0.5);
                v=0.05;
                Direction=1;
                NumberTimesPressed=NumberTimesPressed+1;
            }
            if (NumberTimesPressed%3==0) {
                Excecute=true;
                CheckButton1=false;
                v=0;
                NumberTimesPressed=NumberTimesPressed+1;
            }
        }
        if (Button2==0) {
            CheckButton2=true;
            wait(0.5);
            v=0.05;
            Direction=0;
            NumberTimesPressed2=NumberTimesPressed2+1;
        }
        while (CheckButton2) {
            if (Button2==0) {
                wait(0.5);
                v=0.05;
                Direction=0;
                NumberTimesPressed2=NumberTimesPressed2+1;
            }
            if(NumberTimesPressed2%3==0) {
                Excecute=true;
                CheckButton2=false;
                v=0;
                NumberTimesPressed2=NumberTimesPressed2+1;
            }
        }
        // move to the middle of selected field
        if (Excecute) {
            Vakjex=Rotatie*15/50;
            VakjexNatural=Vakjex;
            if (Vakjex-VakjexNatural>=0.5f) {
                Vakjexround=Vakjex+1;
            } else {
                Vakjexround=Vakjex;
            }
            pc.printf("%f\n",Vakjex);
            pc.printf("%i\n",Vakjexround);
            Goal=Vakjexround*50/15;
        }
        while (Excecute ) {
            Error = Goal-Rotatie; // De error die het motortje maakt ten opzichte van je Goal
            if (fabs(Error)<=0.005) {
                timer.start();
            } else {
                timer.stop();
                timer.reset();
            }
            if (timer.read() >= 2) {
                Excecute=false;
                Excecute2 = true;
                Error = 0;
                Errori = 0;
                Errord = 0;
                v=0;
                timer.stop();
                timer.reset();
            }
        }
        // move y direction
        while (Excecute2) {
            led.write(0);
            if (Button == 0) {
                CheckButton1=true;
                wait(0.5);
                v2=0.05;
                Direction2=1;
                NumberTimesPressed=NumberTimesPressed+1;
            }
            while (CheckButton1) {
                if (Button == 0) {
                    wait(0.5);
                    v2=0.05;
                    Direction2=1;
                    NumberTimesPressed=NumberTimesPressed+1;
                }
                if (NumberTimesPressed%3==0) {
                    Excecute3=true;
                    Excecute2=false;
                    CheckButton1=false;
                    led.write(1);
                    v2=0;
                    NumberTimesPressed=NumberTimesPressed+1;
                }
            }
            if (Button2==0) {
                CheckButton2=true;
                wait(0.5);
                v2=0.05;
                Direction2=0;
                NumberTimesPressed2=NumberTimesPressed2+1;
            }
            while (CheckButton2) {
                if (Button2==0) {
                    wait(0.5);
                    v2=0.05;
                    Direction2=0;
                    NumberTimesPressed2=NumberTimesPressed2+1;
                }
                if(NumberTimesPressed2%3==0) {
                    Excecute3=true;
                    Excecute2=false;
                    CheckButton2=false;
                    led.write(1);
                    v2=0;
                    NumberTimesPressed2=NumberTimesPressed2+1;
                }
            }
            // move to the middle of the field
            if (Excecute3) {
                Vakjey=Rotatie2*15/50;
                VakjeyNatural=Vakjey;
                if (Vakjey-VakjeyNatural>=0.5f) {
                    Vakjeyround=Vakjey+1;
                } else {
                    Vakjeyround=Vakjey;
                }
                Goal2=Vakjeyround*50/15;
            }

        }
        while (Excecute3 ) {
            Error2 = Goal2-Rotatie2; // De error die het motortje maakt ten opzichte van je Goal
            if (fabs(Error2)<=0.005) {
                timer.start();
            } else {
                timer.stop();
                timer.reset();
            }
            if (timer.read() >= 2) {
                Excecute3=false;
                Error2 = 0;
                Errori2 = 0;
                Errord2 = 0;
                v2=0;
                timer.stop();
                timer.reset();
                PakOp();
            }
        }
        if (NumberTimesPakOp%3==0) {
            Excecute4=true;
        }
        while (Excecute4) {
            Goal = 0; // Het doel waar hij naar toe moet
            Goal2=0;
            Error = Goal-Rotatie; // De error die het motortje maakt ten opzichte van je Goal
            Error2=Goal2-Rotatie2;
            if (fabs(Error)<=0.005&&fabs(Error2)<=0.005) {
                timer.start();
            } else {
                timer.stop();
                timer.reset();
            }
            if (timer.read() >= 2) {
                Excecute4 = false;
                Error = 0;
                Errori = 0;
                Errord = 0;
                Error2 = 0;
                Errori2 = 0;
                Errord2 = 0;
                timer.stop();
                timer.reset();
                Encoder.reset();
                Encoder2.reset();
                v=0;
                v2=0;
                NumberTimesPakOp=NumberTimesPakOp+1;
            }
        }
    }
}