// SD Card Test

#include "mbed.h"
#include <fstream>
#include "SDFileSystem.h"

SDFileSystem sd(D4, D5, D3, D10, "sd");
            //(mosi,miso,sclk,cs,name)

char buffer[4096];

void readTest1() {
    printf("\n\rreadTest1() Read /sd/DirX/textfile.txt");
    FileHandle* file = sd.open("/sd/DirX/textfile.txt", O_RDONLY);
    if (file == NULL) {
        printf("\n\r\tFailed sd.open(...)");
    } else {
        printf("\n\rSuccess sd.open(...)");
    }
}

void readTest2() {
    printf("\n\rreadTest2() fopen /sd/DirX/textfile.txt");
    FILE *fp = fopen("/sd/DirX/textfile.txt", "r");
    if (fp == NULL) {
        printf("\n\r\tFailed fopen(...)");
    } else {
        printf("\n\r\tSuccess fopen(...)");
    }
}

void writeFile(){

    const char* filePath = "/sd/DirX/mydir/sdtest.txt";
    printf("\n\rwriteFile() Write to SD card: %s", filePath);
    mkdir("/sd/DirX/mydir", 0777);
    FILE *fp = fopen("/sd/DirX/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        printf("\n\r\tFailed writeFile()");
    }
    else{
        fprintf(fp, "\n\rSuccess writeFile()");
        fclose(fp);
    }
}

int main() {
    printf("\n\rSD Card Test");
    readTest1();
    readTest2();
    writeFile();
}
