#include "mbed.h"
#include "BMP085.h"
#include "ADXL345_I2C.h"

 
//SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
Serial xbee(p13,p14);  // tx, rx 
/*Timeout dater;*/
LocalFileSystem local("local");
Timer timer;

AnalogIn temp_in(p20);
AnalogIn acc_x(p17);
AnalogIn acc_y(p18);
AnalogIn acc_z(p19);
AnalogIn v_out(p16);
AnalogIn light_in(p15);
BMP085 bmp085(p28, p27);
ADXL345_I2C accelerometer(p9, p10);
Serial pc(USBTX, USBRX);


int main() {
    
    float r_temp, temp;
    float vo,ax,ay,az, light,P,t; 

    FILE* fp = NULL;
    fp = fopen("/local/CanSat.txt", "a");
    unsigned count = 0;

   
    int readings[3] = {0, 0, 0};
    
    
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00)){
        xbee.printf("didn't intitialize power control\n"); 
        return 0;  
    }
    //Full resolution, +/-16g, 4mg/LSB.
    wait(.001);
     
    if(accelerometer.setDataFormatControl(0x0B)){
        xbee.printf("didn't set data format\n");
        return 0;  }
    wait(.001);
    
    //3.2kHz data rate.
    if(accelerometer.setDataRate(ADXL345_3200HZ)){
        xbee.printf("didn't set data rate\n");
        return 0;
    }
    wait(.001);

    //Measurement mode.
    
    if(accelerometer.setPowerControl(MeasurementMode)) {
        xbee.printf("didn't set the power control to measurement\n"); 
        return 0;
    }
    
    
    //time_t epoch = 0;

    //fprintf(fp, "E %d \r", epoch);
    timer.start();
        
    while(1){
        //epoch = time(NULL);
        float seconds = timer.read();
        temp = temp_in;
        vo   = v_out/10*33;
        ax = acc_x/10;
        ay = acc_y/10;
        az = acc_z/10;
        light = light_in/10*33;
        r_temp = temp_in * 3.3 * 100 ;   
        bmp085.update();
        P = bmp085.get_pressure();
        t = bmp085.get_temperature();
        
 
        if (fp != NULL) {
            fprintf(fp, "S %f ", seconds);
            fprintf(fp, "T %5.2f ",r_temp);
            fprintf(fp, "H %5.2f ",(vo*8-6)/25+0.06);
//            fprintf(fp, "X %5.2f ",(ax*33-1.65)/0.66);
//            fprintf(fp, "Y %5.2f ",(ay*33-1.65)/0.66);
//            fprintf(fp, "Z %5.2f ",(az*33-1.65)/0.66);
             accelerometer.getOutput(readings);
             fprintf(fp,"X %+4.2f, Y %+4.2f, Z %+4.2f ",
             (float((int16_t)readings[0]+18)/256-0.12), 
             (float((int16_t)readings[1]-4 )/256-0.03), 
             (float((int16_t)readings[2]+22)/256+0.12));
            fprintf(fp, "L %5.2f ",light);
            fprintf(fp, "P %6.2f ", P);
            fprintf(fp, "t %6.2f ", t);
            fprintf(fp,"\n\r");
        //  fclose(fp);
        }//if

        if (count % 10 == 0) { 
            xbee.printf("S %f ", seconds);
            xbee.printf("T %5.2f ",r_temp);
            xbee.printf("H %5.2f ",((vo*8-6)/25+0.11));
//            xbee.printf("X %5.2f ",(ax*33-1.65)/0.66);
//            xbee.printf("Y %5.2f ",(ay*33-1.65)/0.66);
//            xbee.printf("Z %5.2f ",(az*33-1.65)/0.66);
              accelerometer.getOutput(readings);
             pc.printf("X %+4.2f, Y %+4.2f, Z  %+4.2f ",
             (float((int16_t)readings[0]+18)/256), 
             (float((int16_t)readings[1]-4 )/256), 
             (float((int16_t)readings[2]+22)/256));
             xbee.printf("X %+4.2f Y %+4.2f Z  %+4.2f ",
             (float((int16_t)readings[0]+18)/256-0.12), 
             (float((int16_t)readings[1]-4 )/256-0.13), 
             (float((int16_t)readings[2]+22)/256+0.02));
            xbee.printf("L %5.2f ",light);
            xbee.printf("P %6.2f ", P);
            xbee.printf("t %6.2f ", t);
            xbee.printf("\n\r");
        }//if

        ++count;
        wait(0.1);
    }//while
    
}
