//**********************
// UV index meter for mbed with ML8511
//
// UV index
// Extreme 11+
// Very High 8-10
// High 6-7
// Moderate 3-5
// Low 0-2
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"

//#pragma O0
//#pragma O1
//#pragma O2    // default
//#pragma O3
//#pragma Otime
//#pragma Ospace


#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
AnalogIn ain(p15);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
AnalogIn ain(P0_11);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
AnalogIn ain(PA_0);
#endif

AQM0802 lcd(i2c);

int main() {
    
    char msg[10];
    float UV;

    sprintf(msg, "UV index");
    lcd.locate(0,0);
    lcd.print(msg);
      
    while(1) {

        // UV index
        // 1V=0
        // 2V=10
        UV = (ain.read()*3.3-1.0)/(2.0-1.0)*10.0;

        sprintf(msg,"%4.1f",UV);
        lcd.locate(0,1);
        lcd.print(msg);
        wait(1);
    }

}

