//**********************
// Real Time Clock
// RX8025 sample for mbed
//
// Be careful, no parameter check.
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "RX8025.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
RX8025 rx8025(i2c);

// 0=Sun...6=Sat
int zeller(int y, int m, int d){
    
    int i;
    if(m<3){
        --y;
        m+=12;
    }
    i = (y + y/4 - y/100 + y/400 + (13*m + 8)/5 + d) % 7;
    return i;    
}


int main() {
    
    char msg[10];
    Times t;
    Control c;
    Alarmw aw;
    Alarmd ad;

    // set Control
    c.control1=0x20;    // 24hours format
    c.control2=0x00;
    c.offset=0x00;      // to adjust offset
    rx8025.setCONTROL(c);

    // set Alarm with week, as 08:00 at sat.
    // to enable WAFG=1 in contol2
    // you will see WALE=1 in control1 and INTB pin=L, when it happens
    // you should clear WALE
    aw.minute=0x00;
    aw.hour=0x08;
    aw.weekday=0x06;
    rx8025.setALARMw(aw);

    // set Alarm, as 09:00
    // to enable DAFG=1 in contol2
    // you will see DALE=1 in control1 and INTA pin=L, when it happens
    // you should clear DALE
    ad.minute=0x00;
    ad.hour=0x09;
    rx8025.setALARMd(ad);

    // set Time as 2014-01-01 00:00:00
    t.seconds=0x00;
    t.minutes=0x00;
    t.hours=0x00;
    t.weekdays=zeller(2014,1,1);
    t.days=0x01;
    t.months=0x01;
    t.years=0x14;
    rx8025.setTIME(t);
      
    while(1) {

        // Get Time
        t=rx8025.getTIME();

        sprintf(msg,"%02X-%02X-%02X", t.years, t.months, t.days);
        lcd.locate(0,0);
        lcd.print(msg);
        sprintf(msg,"%02X:%02X:%02X", t.hours, t.minutes, t.seconds);
        lcd.locate(0,1);
        lcd.print(msg);
        wait(1);
    }

}


