//**********************
// Barometer and Altimeter
// MPL115A2 sample for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "MPL115.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
MPL115A2 mpl115a2(i2c);

#define T0  288.15
#define dT  0.0065
#define P0  101325.0
#define g   9.80665
#define R   287.052
double GetAltitude(double p, double t){

    return (t+273.15)/dT*(pow((P0/p),dT*R/g)-1);

}

int main() {
    
    char msg[10];
    int p, t, a;

    sprintf(msg,"Barometer");
    lcd.locate(0,0);
    lcd.print(msg);
    sprintf(msg,"Altimeter");
    lcd.locate(0,1);
    lcd.print(msg);
    wait(1);
      
    while(1) {

        p = ( (double)mpl115a2.pressure()/16.0 * (115.0-50.0)/1023.0 +  50.0 ) * 1000.0;
        t = 25.0 - ((double)mpl115a2.temperature() - 498.0) / 5.35;
        a = GetAltitude(p,t);

        sprintf(msg,"%6dPa",p);
        lcd.locate(0,0);
        lcd.print(msg);
        sprintf(msg,"%4dm%2dC", a, t);
        lcd.locate(0,1);
        lcd.print(msg);
        wait(1);
    }

}


