//**********************
// DDS with DAC 12bits
// MCP4726 sample for mbed
//
// output
// (1)sin wave with DDS, 1Hz-1KHz
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "MCP4726.h"

#define PI 3.14159265
// sampling frequency for DDS
// 400KHz
#define S   8400
// 1MHz
//#define S   12000

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif
AQM0802 lcd(i2c);
MCP4726 mcp4726(i2c);
Ticker dds;

unsigned short f;
unsigned short sin_table[360];


void sampling()
{
    static int t=0;
    unsigned short x;
    float a;

    x=360*modff((float)f*t/S,&a);
    x = sin_table[x];
    if(++t>=S)t=0;

    // D/A
    mcp4726.put(x);
}


int main() {
    
    char msg[10];
    int i;
    
    // to make 12bits sine table
    for(i=0;i<360;i++){
        sin_table[i]=0x7ff*sin(2*PI/360*i)+0x7ff;
    }

    // start signal with sampling
    dds.attach_us(&sampling,1000000/S);    // for us

    while(1){
        // Set f, test signal
        // 10-1KHz
        for(f=10;f<=1000;f+=10){
            sprintf(msg, "%5d Hz", f );
            __disable_irq();
            lcd.locate(0,0);
            lcd.print(msg);
            __enable_irq();
            wait(1);
        }
    }

}


