//**********************
// potension registor with 7bits
// MCP4018 sample for mbed
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "MCP4018.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif
AQM0802 lcd(i2c);
MCP4018 mcp4018(i2c);


int main() {
    
    char msg[10];
    unsigned char i;
    
    while(1){
        for(i=0;i<0x80;i++){
            mcp4018.put(i);
            sprintf(msg, "%5dOhm" , 10000/127*i+75 );
            lcd.locate(0,0);
            lcd.print(msg);
            wait(1);
        }
    }

}


