//**********************
// A/D Converter
// MCP3425 sample for mbed
//
// Voltage=(Vin+)-(Vin-)
// Voltage Range:-2.048V to 2.048V
// Resolution:2.048V/0x7FFF=62.5uV, 16bits
// Sampling Per Second
// 240 SPS, 12bits
//  60 SPS, 14bits
//  15 SPS, 16bits (default)
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "MCP3425.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
MCP3425 mcp3425(i2c);


int main() {
    
    char msg[10];
    short a;
    float v;

    sprintf(msg,"MCP3425");
    lcd.locate(0,0);
    lcd.print(msg);
    wait(1);
      
    while(1) {

        a = mcp3425.get();
        sprintf(msg,"dat=%X",(unsigned short)a);
        lcd.locate(0,0);
        lcd.print(msg);
        v = (float)a*2.048/0x7FFF;
        sprintf(msg,"%f",v);
        lcd.locate(0,1);
        lcd.print(msg);
        wait(1);    // Do not exceed 15SPS with 16bits
    }

}

