//**********************
// Infrared Rays receiver and transceiver sample for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo F401RE flash=512KB, ADC=12bits
//
// (C)Copyright 2014-2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "IR.h"

//#pragma O0
//#pragma O1
//#pragma O2
//#pragma O3    // default
//#pragma Otime // default
//#pragma Ospace


#if defined(TARGET_LPC1768)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
I2C i2c(p28,p27);
AnalogIn ain(p15);
#endif
// for TG-LPC11U35-501
#if defined (TARGET_LPC11U35_501)
DigitalOut led1(P0_20);
DigitalOut led2(P0_21);
I2C i2c(P0_5,P0_4);
AnalogIn ain(P0_11);
#endif
// for Nucleo
#if defined (TARGET_NUCLEO_F401RE)
DigitalOut led1(D13);
I2C i2c(D14,D15);
AnalogIn ain(PA_0);
#endif

AQM0802 lcd(i2c);
IR ir(P0_12,P0_7);
InterruptIn button(P0_12);

void irInterrupt()
{
    led1=!led1;
    button.disable_irq();   // !!! not work !!!
    ir.getIR();
    button.enable_irq();
    
    // To do something, code here
    
}


int main() {
    
    char msg[10];
    char i,n;
    char name[][5]={"none","NEC ","AEHA","SONY"};
    
    button.fall(&irInterrupt);
    button.mode(PullUp);
    
    sprintf(msg, "%d", SystemCoreClock );
    lcd.locate(0,0);
    lcd.print(msg);
    wait(1);    

    while(1) {

        lcd.locate(0,0);
        sprintf(msg,"%s",name[ir.mode]);    // 1:NEC, 2:AEHA, 3:SONY
        lcd.print(msg);
        sprintf(msg,"%4d",ir.bits);    // bits
        lcd.print(msg);

        // scroll
        n=(ir.bits+7)/8;    // bits to n bytes
        for(i=0;i<n;i++){
            lcd.locate(0,1);
            sprintf(msg,"buf%02d=%02X",i,ir.buf[i]);  // data
            lcd.print(msg);
            wait(1);
        }
        

        // Echo back
        button.fall(NULL);          // disable Interrupt
        // set parameter to send out
        // ir.mode is 1:NEC, 2:AEHA or 3:SONY
        // ir.bits is number to send out less than IR_LIMITS x8
        // ir.buf[] are bytes buffer
        ir.setIR();
        button.fall(&irInterrupt);  // enable Interrupt
        lcd.locate(0,1);
        sprintf(msg,"sent out");
        lcd.print(msg);
        wait(1);
        
    }

}


