//**********************
// Hygrometer and Thermometer for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "HDC1000.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
HDC1000 hdc1000(i2c);

int main() {
    
    char msg[10];
    float h;
    float t;
      
    while(1) {

        h = hdc1000.humidity();
        h = h/0x10000*100;
        sprintf(msg,"%4.1f%% ",h);
        lcd.locate(0,0);
        lcd.print(msg);

        t = hdc1000.temperature();
        t = t/0x10000*165-40;
        sprintf(msg,"%4.1fC ",t);
        lcd.locate(0,1);
        lcd.print(msg);

        wait(1);
    }

}
