//**********************
// EEPROM sample for TG-LPC11U35-501
//
// via IAP
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "EEPROM.h"

I2C i2c(P0_5,P0_4);
AQM0802 lcd(i2c);
EEPROM eeprom;

int main() {

    char RAM[4096];
    char msg[10];
    int i;

    eeprom.put(0,10);
    i=eeprom.get(0);
    sprintf(msg, "test=%d", i );
    lcd.locate(0,0);
    lcd.print(msg);
    wait(1);    
    
    for(i=0;i<100;i++)
        RAM[i]=i;
    i=eeprom.write(0,RAM,100);
    sprintf(msg, "write=%d", i );
    lcd.locate(0,0);
    lcd.print(msg);
    wait(1);

    i=eeprom.read(0,RAM,4096-64);
    sprintf(msg, "read=%d ", i );
    lcd.locate(0,0);
    lcd.print(msg);
    wait(1);

    for(i=0;i<4096;i++){
        sprintf(msg, "adr=%4d", i );
        lcd.locate(0,0);
        lcd.print(msg);
        sprintf(msg, "dat=%02X", RAM[i] );
        lcd.locate(0,1);
        lcd.print(msg);
        wait(1);
    }
    
    while(1);

}
