//**********************
// Barometer and Temperature for mbed
//
// LPC1768 flash=512KB
// LPC11U35 flash=64KB
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "ADT7410.h"
#include "LPS331.h"
#include "M24LC64.h"
#include "PCF8591.h"

//#pragma O0
//#pragma O1
//#pragma O2
//#pragma O3
//#pragma Otime
//#pragma Ospace

// To select functions
//#define EEPROM
//#define ADCON
#define TEMP
#define BAR

#if defined(TARGET_LPC1768)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined (TARGET_LPC11U35_501)
DigitalOut led1(P0_20);
DigitalOut led2(P0_21);
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined (TARGET_NUCLEO_F401RE)
DigitalOut led1(D13);
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
#ifdef TEMP
ADT7410 temperature(i2c);
#endif
#ifdef BAR
LPS331 barometer(i2c);
#endif
#ifdef EEPROM
M24LC64 eeprom(i2c);
#endif
#ifdef ADCON
PCF8591 adc(i2c);
#endif

int main() {
    
    char msg[10];
#ifdef TEMP
    int temp;
#endif
#ifdef BAR
    long press;
#endif
#ifdef EEPROM
    int l;
    unsigned char eep;
#endif
#ifdef ADCON
    unsigned char d;
#endif

//    i2c.frequency(100000);  // default 100Kbps
    sprintf(msg, "%d", SystemCoreClock );
    lcd.locate(0,0);
    lcd.print(msg);
    wait_ms(1000);    
      
    while(1) {

#ifdef EEPROM
        // EEPROM 0x0002=0x5A
        eeprom.put(0x0002, 0x5A);

        for(l=0;l<0x1FFF;l++){
            // EEPROM for 24LC64
            eep=eeprom.get(l);
            sprintf(msg,"ADR=%4d",l);
            lcd.locate(0,0);
            lcd.print(msg);
            sprintf(msg,"DAT=%2X  ",eep);
            lcd.locate(0,1);
            lcd.print(msg);
            wait_ms(1000);
        }
#endif

#ifdef ADCON
        // A/D for PCF8591
        d=adc.get(0x40);  // ch0 with D/A enable
//      d=adc.get(0x01);  // ch1
//      d=adc.get(0x02);  // ch2
//      d=adc.getI2C(0x03);  // ch3
        sprintf(msg,"A/D=%3d ",d);
        lcd.locate(0,0);
        lcd.print(msg);
        // D/A for PCF8591
        adc.put(0x40, d);
        wait_ms(1000);
//        wait(1.0); bug for Nucleo

#endif

#ifdef TEMP
        // Temperature
        temp=temperature.value();
//      temp/=128;  // for C
        temp/=13;
        sprintf(msg,"%2d.%1dC   ",temp/10,temp%10);
        lcd.locate(0,0);
        lcd.print(msg);
        
        led1 = 1;   // off
//        led2 = 1;
        wait_ms(500);
#endif

#ifdef BAR
        // Barometer
        press=barometer.value();
//      press/=4096;    // for hPa
        press/=41;
        sprintf(msg,"%dPa ",press);
        lcd.locate(0,1);
        lcd.print(msg);
        
        led1 = 0;   // on
 //       led2 = 0;
        wait_ms(500);
#endif
    }

}

