//**********************
// Hygrometer, Thermometer and Pressure for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "BME280.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
BME280 bme280(i2c);

int main() {
    
    char msg[10];
    float h;
    float t;
    float p;
      
    while(1) {

        h = bme280.humidity();
        h = h/1024;
        sprintf(msg,"%5.2f%%  ",h);
        lcd.locate(0,0);
        lcd.print(msg);
        wait(2);

        t = bme280.temperature();
        t = t/100;
        sprintf(msg,"%5.2fC  ",t);
        lcd.locate(0,0);
        lcd.print(msg);
        wait(2);

        p = bme280.pressure();
        p = p/256;
        sprintf(msg,"%6.0fPa ",p);
        lcd.locate(0,0);
        lcd.print(msg);
        wait(2);
    }

}

