//**********************
// USB current meter for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"

//#pragma O0
//#pragma O1
//#pragma O2
//#pragma O3        // default
//#pragma Otime     // default
//#pragma Ospace


#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
AnalogIn ain(p15);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
AnalogIn ain(P0_11);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
AnalogIn ain(PA_0);
#endif

AQM0802 lcd(i2c);
Ticker tic;


void display()
{

    char msg[10];
    int mA;
    static int mAh=0;

    // current
    mA = ain.read()*3.3*1000;
    mAh+=mA;
    if(mAh/3600>99999)mAh=0;    // overflow

    sprintf(msg," %4dmA ",mA);
    lcd.locate(0,0);
    lcd.print(msg);
    
    sprintf(msg,"%5dmAh",mAh/3600);
    lcd.locate(0,1);
    lcd.print(msg);

}

int main() {
        
    tic.attach(&display,1);    // Do not exceed 2147sec

    while(true) {
    }

}
