//**********************
// Hygrometer and Thermometer for mbed
//
// LPC1768 flash=512KB, ADC=12bits
// LPC11U35 flash=64KB, ADC=10bits
// Nucleo ADC=12bits
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#include "mbed.h"
#include "AQM0802.h"
#include "AM2320.h"

#if defined(TARGET_LPC1768)
I2C i2c(p28,p27);
#endif
// for TG-LPC11U35-501
#if defined(TARGET_LPC11U35_501)
I2C i2c(P0_5,P0_4);
#endif
// for Nucleo
#if defined(TARGET_NUCLEO_F401RE)
I2C i2c(D14,D15);
#endif

AQM0802 lcd(i2c);
AM2320 am2320(i2c);

int main() {
    
    char msg[10];
    int h;
    int t;
      
    while(1) {

        h = am2320.humidity();
        sprintf(msg,"%4.1f%% ",h/10.0);
        lcd.locate(0,0);
        lcd.print(msg);

        t = am2320.temperature();
        sprintf(msg,"%4.1fC ",t/10.0);
        lcd.locate(0,1);
        lcd.print(msg);

        wait(1);
    }

}
