//**********************
// RX8025.h for mbed
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#ifndef RX8025_H_
#define RX8025_H_

#define RX8025_ADDR                 0x64
#define RX8025_SECONDS              0x00
#define RX8025_MINUTES              0x10
#define RX8025_HOURS                0x20
#define RX8025_WEEKDAYS             0x30
#define RX8025_DAYS                 0x40
#define RX8025_MONTHS               0x50
#define RX8025_YEARS                0x60
#define RX8025_OFFSET               0x70
#define RX8025_ALARM_W_M            0x80
#define RX8025_ALARM_W_H            0x90
#define RX8025_ALARM_W_W            0xA0
#define RX8025_ALARM_D_M            0xB0
#define RX8025_ALARM_D_H            0xC0
#define RX8025_CONTROL1             0xE0
#define RX8025_CONTROL2             0xF0

#include "mbed.h"

typedef struct {
    unsigned char seconds;
    unsigned char minutes;
    unsigned char hours;
    unsigned char weekdays;
    unsigned char days;
    unsigned char months;
    unsigned char years;
}Times;


typedef struct {
    unsigned char minute;
    unsigned char hour;
    unsigned char weekday;
}Alarmw;


typedef struct{
    unsigned char minute;
    unsigned char hour;
}Alarmd;


typedef struct{
    unsigned char control1;
    unsigned char control2;
    unsigned char offset;
}Control;


class RX8025{
public:
    RX8025 (PinName sda, PinName scl);
    RX8025 (I2C& p_i2c);
    void init();

    void put(unsigned char a, unsigned char b);
    void get(unsigned char a);
    Times getTIME();
    void setTIME(Times t);
    Alarmw getALARMw();
    void setALARMw(Alarmw a);
    Alarmd getALARMd();
    void setALARMd(Alarmd a);
    Control getCONTROL();
    void setCONTROL(Control c);

protected:
    
    I2C _i2c;

    Times time;
    Alarmw alarmw;
    Alarmd alarmd;
    Control control;
    char buf[2];

};

#endif /* RX8025_H_ */


