//**********************
// RX8025.cpp for mbed
//
// RX8025 rx8025(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// RX8025 rx8025(i2c);
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "RX8025.h"

RX8025::RX8025 (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
RX8025::RX8025 (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}

void RX8025::put(unsigned char a, unsigned char b)
{
    wait_us(100);   // wait 62us
    buf[0]=a;
    buf[1]=b;
    _i2c.write(RX8025_ADDR, buf, 2);
}


void RX8025::get(unsigned char a)
{
    wait_us(100);   // wait 62us
    buf[0] = a;
    _i2c.write(RX8025_ADDR, buf, 1, true); // no stop, repeated
    _i2c.read( RX8025_ADDR, buf, 1);

}


Times RX8025::getTIME()
{
    get(RX8025_SECONDS);
    time.seconds=buf[0];
    get(RX8025_MINUTES);
    time.minutes=buf[0];
    get(RX8025_HOURS);
    time.hours=buf[0];
    get(RX8025_WEEKDAYS);
    time.weekdays=buf[0];
    get(RX8025_DAYS);
    time.days=buf[0];
    get(RX8025_MONTHS);
    time.months=buf[0];
    get(RX8025_YEARS);
    time.years=buf[0];
    return time;
}


void RX8025::setTIME(Times t)
{
    put(RX8025_SECONDS, t.seconds);
    put(RX8025_MINUTES, t.minutes);
    put(RX8025_HOURS, t.hours);
    put(RX8025_WEEKDAYS, t.weekdays);
    put(RX8025_DAYS, t.days);
    put(RX8025_MONTHS, t.months);
    put(RX8025_YEARS, t.years);
}


Alarmw RX8025::getALARMw()
{
    get(RX8025_ALARM_W_M);
    alarmw.minute=buf[0];
    get(RX8025_ALARM_W_H);
    alarmw.hour=buf[0];
    get(RX8025_ALARM_W_W);
    alarmw.weekday=buf[0];
    return alarmw;
}


void RX8025::setALARMw(Alarmw a)
{
    put(RX8025_ALARM_W_M, a.minute);
    put(RX8025_ALARM_W_H, a.hour);
    put(RX8025_ALARM_W_W, a.weekday);
}


Alarmd RX8025::getALARMd()
{
    get(RX8025_ALARM_D_M);
    alarmd.minute=buf[0];
    get(RX8025_ALARM_D_H);
    alarmd.hour=buf[0];
    return alarmd;
}


void RX8025::setALARMd(Alarmd a)
{
    put(RX8025_ALARM_D_M, a.minute);
    put(RX8025_ALARM_D_H, a.hour);
}


Control RX8025::getCONTROL()
{
    get(RX8025_CONTROL1);
    control.control1=buf[0];
    get(RX8025_CONTROL2);
    control.control2=buf[0];
    get(RX8025_OFFSET);
    control.offset=buf[0];
    return control;
}


void RX8025::setCONTROL(Control c)
{
    put(RX8025_CONTROL1, c.control1);
    put(RX8025_CONTROL2, c.control2);
    put(RX8025_OFFSET, c.offset);
}


void RX8025::init()
{
    control.control1=0x00;
    control.control2=0x20;
    control.offset=0x00;
    setCONTROL(control);
}


