//**********************
// PCF8591.cpp for mbed
//
// PCF8591 lcd(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// PCF8591 lcd(i2c);
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "PCF8591.h"

PCF8591::PCF8591 (PinName sda, PinName scl) : _i2c(sda, scl) {
}
PCF8591::PCF8591 (I2C& p_i2c) : _i2c(p_i2c) {
}

void PCF8591::put(unsigned char a, unsigned char b)
{
    buf[0]=a;
    buf[1]=b;
    _i2c.write(PCF8591_ADDR, buf, 2);
}

unsigned char PCF8591::get(unsigned char a)
{
    buf[0] = a;
    _i2c.write(PCF8591_ADDR, buf, 1, true); // no stop, repeated
    _i2c.read( PCF8591_ADDR, buf, 1);
    return buf[0];
}


